<?php

declare(strict_types=1);

namespace NoahVet\Reef\Factory\RequestContext;

use Symfony\Component\HttpFoundation\Request;

class SortingApplier extends AbstractApplier implements SortingApplierInterface
{
    public function apply(Request $request, array $whitelist): array
    {
        $sortingKeys = \array_filter(
            $request->query->all(),
            fn ($queryParam) => \str_starts_with($queryParam, 'sort'),
            \ARRAY_FILTER_USE_KEY,
        );

        foreach ($sortingKeys as $sortingKey => $sortingValue) {
            if (!\array_key_exists($sortingKey, \array_flip($whitelist['sorting']))
                && ('ASC' === $sortingValue || 'DESC' === $sortingValue)
            ) {
                unset($sortingKeys[$sortingKey]);
            }
        }

        return $sortingKeys;
    }
}
