<?php

declare(strict_types=1);

namespace NoahVet\Reef\Factory\RequestContext;

use NoahVet\Reef\Bridge\Reef\IAM\Client\ClientAdapter;
use NoahVet\Reef\Bridge\Reef\IAM\Factory\IAMFactoryFacadeInterface;
use NoahVet\Reef\Domain\Tool\ArrayTool;
use NoahVet\Reef\Security\IAM\Model\ResourceType;
use NoahVet\Reef\Security\ResourceType\ResourceCollectionPermissionFetcherInterface;
use Symfony\Component\HttpFoundation\Request;

class PermissionApplier extends AbstractApplier implements PermissionApplierInterface
{
    public function __construct(
        private readonly ClientAdapter $clientAdapter,
        private readonly ResourceCollectionPermissionFetcherInterface $resourceCollectionPermissionFetcher,
    ) {
    }

    public function apply(Request $request, array $whitelist): array
    {
        $permissions = [];

        if (!isset($whitelist['permissions'])) {
            return [];
        }

        foreach ($whitelist['permissions'] as $context) {
            // Fetch IAM Authorization List
            $iamPermissions = $this->resourceCollectionPermissionFetcher->fetch(
                ResourceType::fromString(IAMFactoryFacadeInterface::BSM_RESOURCE_PREFIX.$context['resourceName']),
                true,
                $this->clientAdapter->getToken()->getBearerToken(),
            );

            // Get global permission
            $iamAllPermissions = $iamPermissions->getAllPermissions();

            // Get specific permissions, by resource 'id'
            $iamResourcePermissions = $iamPermissions->getResourcePermissions();

            // If you don't have all permissions on this resource type
            if (!\in_array($context['permissionSlug'], $iamAllPermissions)) {
                $permissions[$context['mappedKey']] = ArrayTool::removeDuplicateValues(
                    \array_keys($iamResourcePermissions),
                );
            }
        }

        return $permissions;
    }
}
