<?php

declare(strict_types=1);

namespace NoahVet\Reef\Factory\RequestContext;

use NoahVet\Reef\Domain\Tool\ArrayTool;
use Symfony\Component\HttpFoundation\Request;

class FilterApplier extends AbstractApplier implements FilterApplierInterface
{
    /**
     * Build an array containing the filters present in the whitelist and the http request.
     */
    public function apply(Request $request, array $whitelist): array
    {
        $filters = [];

        foreach ($whitelist['filters'] as $supportedFilter) {
            if ($request->query->has($supportedFilter)) {
                $filters[$supportedFilter] = ArrayTool::removeDuplicateValues(
                    $request->query->all($supportedFilter),
                );
            }
        }

        return $filters;
    }
}
