<?php

declare(strict_types=1);

namespace NoahVet\Reef\Exception;

class IAMException extends \Exception
{
    protected ?string $responseBody;

    public function __construct(string $message = '', int $code = 0, string $responseBody = null)
    {
        parent::__construct($message, $code);

        $this->responseBody = $responseBody;
    }

    public function getResponseBody(): ?string
    {
        return $this->responseBody;
    }
}
