<?php

declare(strict_types=1);

namespace NoahVet\Reef\Domain\Tool;

class VatTool implements VatToolInterface
{
    public static function addVat(int $amount, int $vatAmount): int
    {
        return (int) ($amount * (1 + $vatAmount / 10000));
    }

    public static function removeVat(int $amount, int $vatAmount): int
    {
        return (int) ($amount / (1 + $vatAmount / 10000));
    }
}
