<?php

declare(strict_types=1);

namespace NoahVet\Reef\Domain\Tool;

class StringTool implements StringToolInterface
{
    public static function fromBurgerCaseToSnakeCase(string $subject): string
    {
        return \mb_strtolower(\str_replace('-', '_', \trim($subject)));
    }

    public static function fromPascalCaseToCamelCase(string $subject): string
    {
        return \lcfirst(\trim($subject));
    }

    public static function fromSpacedToPascalCase(string $subject): string
    {
        return \ucwords(
            \mb_strtolower(
                \trim($subject),
            ),
        );
    }

    public static function fromSpacedToSnakeUpperCase(string $subject): string
    {
        return \mb_strtoupper(
            \str_replace(
                ' ',
                '_',
                \trim($subject),
            ),
        );
    }

    public static function toLowerCaseWithoutAccent(string $subject): string
    {
        return self::removeAccent(
            \mb_strtolower($subject),
        );
    }

    public static function toUpperCaseWithoutAccent(string $subject): string
    {
        return self::removeAccent(
            \mb_strtoupper($subject),
        );
    }

    public static function removeAccent(string $subject): string
    {
        return \str_replace(
            \mb_str_split(self::CHAR_LIST_WITH_ACCENT),
            \mb_str_split(self::LOWER_CASE_LIST_WITH_ACCENT.self::UPPER_CASE_LIST_WITH_ACCENT),
            \trim($subject),
        );
    }

    public static function removeWhitespace(string $subject): string
    {
        return \str_replace(
            ' ',
            '',
            $subject,
        );
    }

    public static function toName(string $name, array $supportedSeparators = self::SUPPORTED_SEPARATORS): string
    {
        $name = \ucwords(\mb_strtolower(\trim($name)));

        foreach ($supportedSeparators as $separator) {
            if (\str_contains($name, $separator) && !empty($separator)) {
                $namePart = \explode($separator, $name);
                $name = \implode(
                    $separator,
                    \array_map(
                        'ucfirst',
                        \array_map(
                            'mb_strtolower',
                            $namePart,
                        ),
                    ),
                );
            }
        }

        return $name;
    }
}
