<?php

declare(strict_types=1);

namespace NoahVet\Reef\Controller\Common;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use NoahVet\Reef\Controller\AbstractController;
use NoahVet\Reef\Entity\EntityInterface;
use NoahVet\Reef\Mapper\Common\One\Create\AbstractCreateMapperInterface;
use NoahVet\Reef\Mapper\Common\One\Update\AbstractUpdateMapperInterface;
use NoahVet\Reef\Repository\BaseRepositoryInterface;
use Symfony\Component\HttpFoundation\Exception\BadRequestException;

abstract class AbstractBulkUpdateController extends AbstractController
{
    /**
     * @param class-string<object> $requestDtoFqcn
     *
     * @return Collection<int, EntityInterface>
     */
    protected function deserializeRequest(
        AbstractUpdateMapperInterface $mapper,
        BaseRepositoryInterface $resourceRepository,
        string $requestDtoFqcn,
    ): Collection {
        $payloadAsArray = \json_decode($this->request->getContent(), true);
        /** @var Collection<int, EntityInterface> $entities */
        $entities = new ArrayCollection();

        foreach ($payloadAsArray['resources'] as $resourceKeyValue) {
            /** @var EntityInterface|null $associatedResource */
            $associatedResource = $resourceRepository->findOneBy($resourceKeyValue);
            if (!$associatedResource) {
                throw new BadRequestException('At least one resource is incorrect.');
            }

            $entities->add(
                $mapper->mapRequestDtoToEntity(
                    $mapper->mapDataToRequestDto(
                        $this->request->getContent(),
                        $requestDtoFqcn,
                        $associatedResource,
                    ),
                ),
            );
        }

        return $entities;
    }

    /**
     * @param class-string<object> $responseDtoFqcn
     *
     * @return array<string, mixed>
     */
    protected function serializeResponse(
        AbstractCreateMapperInterface $mapper,
        EntityInterface $entity,
        string $responseDtoFqcn,
    ): array {
        return $mapper->normalizeResponseDto(
            $mapper->mapEntityToResponseDto(
                $entity,
                $responseDtoFqcn,
            ),
        );
    }
}
