<?php

declare(strict_types=1);

namespace NoahVet\Reef\Command\RabbitMQ;

use NoahVet\Reef\RabbitMQ\Consumer\Factory\ReefMQConsumerFactory;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

#[AsCommand(name: 'reef:rabbitmq:process')]
class RabbitMQProcessCommand extends Command
{
    public function __construct(
        private readonly ReefMQConsumerFactory $taskConsumerFactory,
    ) {
        parent::__construct('reef:rabbitmq:process');
    }

    public function execute(InputInterface $input, OutputInterface $output): int
    {
        $consumer = $this->taskConsumerFactory->createConsumer();

        if (
            \function_exists('pcntl_signal')
            && \defined('SIGTERM')
            && \defined('SIGINT')
        ) {
            \pcntl_signal(\SIGTERM, fn () => $consumer->stopConsume());
            \pcntl_signal(\SIGINT, fn () => $consumer->stopConsume());
        }

        try {
            while ($consumer->isOpen()) {
                $consumer->consume();
            }
        } catch (\Exception) {
            return self::FAILURE;
        }

        return self::SUCCESS;
    }

    protected function configure(): void
    {
        $this->setDescription('Wait for incoming messages from RabbitMQ');
    }
}
