<?php

declare(strict_types=1);

namespace NoahVet\Reef\Business\Model;

class TeamMember
{
    public function __construct(
        protected string $uuid,
        protected string $jobTitle,
        protected ?\DateTimeImmutable $entryDate,
        protected ?\DateTimeImmutable $exitDate,
    ) {
    }

    public function getUuid(): string
    {
        return $this->uuid;
    }

    public function getJobTitle(): string
    {
        return $this->jobTitle;
    }

    public function getEntryDate(): ?\DateTimeImmutable
    {
        return $this->entryDate;
    }

    public function getExitDate(): ?\DateTimeImmutable
    {
        return $this->exitDate;
    }
}
