<?php

declare(strict_types=1);

namespace NoahVet\Reef\Business\Model\Factory;

use NoahVet\Reef\Business\Enumerator\VeterinaryEstablishmentTeamMembersEnumerator;
use NoahVet\Reef\Business\Model\EstablishmentWithTeam;
use NoahVet\Reef\Business\Model\TeamMember;
use NoahVet\Reef\Jane\Model\VeterinaryEstablishmentResponseItem;
use NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserResponseItem;

class EstablishmentWithTeamFactory
{
    public function __construct(
        protected VeterinaryEstablishmentTeamMembersEnumerator $establishmentTeamMembersEnumerator,
        protected TeamMemberFactory $teamMemberFactory,
    ) {
    }

    /**
     * @param array<int, VeterinaryEstablishmentResponseItem> $establishments
     *
     * @return EstablishmentWithTeam[]
     */
    public function createBatch(array $establishments): array
    {
        $teamMembers = $this->establishmentTeamMembersEnumerator->getTeamMembers($establishments);

        return \array_map(
            fn (VeterinaryEstablishmentResponseItem $est): EstablishmentWithTeam => $this->build(
                $est,
                $teamMembers[$est->getId()] ?? [],
            ),
            $establishments,
        );
    }

    public function create(
        VeterinaryEstablishmentResponseItem $establishment,
    ): EstablishmentWithTeam {
        $teamMembers = $this->establishmentTeamMembersEnumerator->getTeamMembers([$establishment]);

        return $this->build(
            $establishment,
            $teamMembers[$establishment->getId()] ?? [],
        );
    }

    /**
     * @param array<VeterinaryEstablishmentUserResponseItem> $teamMembers
     */
    protected function build(
        VeterinaryEstablishmentResponseItem $establishment,
        array $teamMembers,
    ): EstablishmentWithTeam {
        return new EstablishmentWithTeam(
            $establishment->getId(),
            $establishment->getPrivilegedCode(),
            \array_map(
                fn (VeterinaryEstablishmentUserResponseItem $member): TeamMember => $this->teamMemberFactory->create(
                    $member,
                ),
                $teamMembers,
            ),
        );
    }
}
