<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Security;

use NoahVet\Reef\Security\IAM\TokenExchange\TokenExchangerInterface;
use NoahVet\Reef\Security\ReefOAuthAuthenticator;
use NoahVet\Reef\Security\Token\JWTDecoderInterface;
use NoahVet\Reef\Security\User\Provider\ReefOAuthUserProviderInterface;
use NoahVet\Reef\Security\User\ReefOAuthUser;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;

class ReefOAuthAuthenticatorTest extends TestCase
{
    /**
     * @var ReefOAuthUserProviderInterface&MockObject
     */
    private ReefOAuthUserProviderInterface $userProvider;

    /**
     * @var JWTDecoderInterface&MockObject
     */
    private readonly JWTDecoderInterface $JWTDecoder;

    /**
     * @var TokenExchangerInterface&MockObject
     */
    private readonly TokenExchangerInterface $tokenExchanger;

    private ReefOAuthAuthenticator $authenticator;

    protected function setUp(): void
    {
        $this->JWTDecoder = $this->createMock(JWTDecoderInterface::class);
        $this->tokenExchanger = $this->createMock(TokenExchangerInterface::class);
        $this->userProvider = $this->createMock(ReefOAuthUserProviderInterface::class);

        $this->authenticator = new ReefOAuthAuthenticator(
            $this->JWTDecoder,
            'reef-client-id',
            $this->tokenExchanger,
            $this->userProvider,
        );
    }

    public function testLoadUserNoCache(): void
    {
        $userMock = $this->createMock(ReefOAuthUser::class);
        $this->userProvider
            ->method('loadUser')
            ->with('bearer')
            ->willReturn($userMock)
        ;

        $user = $this->authenticator->loadUser('bearer');
        self::assertSame($userMock, $user);
    }
}
