<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\RabbitMQ\Task\Factory;

use NoahVet\Reef\RabbitMQ\Task\ConsoleCommandTask;
use NoahVet\Reef\RabbitMQ\Task\Factory\ConsoleCommandTaskFactory;
use NoahVet\Reef\RabbitMQ\Task\Factory\ConsoleCommandTaskFactoryInterface;
use PHPUnit\Framework\TestCase;
use Symfony\Component\Console\Command\Command;

class ReefTaskSenderFactoryTest extends TestCase
{
    private ConsoleCommandTaskFactoryInterface $subject;

    protected function setUp(): void
    {
        parent::setUp();
        $this->subject = new ConsoleCommandTaskFactory();
    }

    public function testCreateReturnsInternalTaskInstance(): void
    {
        $command = $this->createMock(Command::class);
        $arguments = ['--force' => true];

        $task = $this->subject->create($command, $arguments);

        $this->assertInstanceOf(ConsoleCommandTask::class, $task);
    }

    public function testCreateInitializesTaskWithCommandAndArguments(): void
    {
        $command = $this->createMock(Command::class);
        $arguments = ['--dry-run' => true];

        /** @var ConsoleCommandTask $task */
        $task = $this->subject->create($command, $arguments);

        $this->assertSame($arguments, $task->arguments);
        $this->assertSame($command, $task->command);
    }
}
