<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\RabbitMQ\Task\Facade;

use NoahVet\Reef\RabbitMQ\Task\Facade\ReefTaskSenderFacade;
use NoahVet\Reef\RabbitMQ\Task\Facade\ReefTaskSenderFacadeInterface;
use NoahVet\Reef\RabbitMQ\Task\Factory\ConsoleCommandTaskFactoryInterface;
use NoahVet\Reef\RabbitMQ\Task\InternalTaskInterface;
use NoahVet\Reef\RabbitMQ\Task\Sender\ReefTaskSenderInterface;
use PHPUnit\Framework\TestCase;
use Symfony\Component\Console\Command\Command;

class ReefTaskSenderFacadeTest extends TestCase
{
    private ReefTaskSenderFacadeInterface $subject;

    private ReefTaskSenderInterface $reefTaskSender;

    private ConsoleCommandTaskFactoryInterface $commandTaskFactory;

    protected function setUp(): void
    {
        parent::setUp();

        $this->reefTaskSender = $this->createMock(
            ReefTaskSenderInterface::class,
        );
        $this->commandTaskFactory = $this->createMock(
            ConsoleCommandTaskFactoryInterface::class,
        );

        $this->subject = new ReefTaskSenderFacade(
            $this->reefTaskSender,
            $this->commandTaskFactory,
        );
    }

    public function testSendConsoleCommandTaskCreatesTaskAndSendsIt(): void
    {
        $command = $this->createMock(Command::class);
        $arguments = ['--env' => 'dev'];

        $task = $this->createMock(InternalTaskInterface::class);

        $this->commandTaskFactory
            ->expects($this->once())
            ->method('create')
            ->with($command, $arguments)
            ->willReturn($task)
        ;

        $this->reefTaskSender
            ->expects($this->once())
            ->method('sendTask')
            ->with($task)
        ;

        $this->subject->sendConsoleCommandTask($command, $arguments);
    }
}
