<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Jane;

use NoahVet\Reef\Jane\Normalizer\JaneObjectNormalizer;
use PHPUnit\Framework\TestCase;
use Symfony\Component\Serializer\Encoder\JsonDecode;
use Symfony\Component\Serializer\Encoder\JsonEncode;
use Symfony\Component\Serializer\Encoder\JsonEncoder;
use Symfony\Component\Serializer\Normalizer\ArrayDenormalizer;
use Symfony\Component\Serializer\Serializer;
use Symfony\Component\Serializer\SerializerInterface;

abstract class AbstractJaneTest extends TestCase
{
    protected function getSerializer(): SerializerInterface
    {
        return new Serializer(
            [
                new ArrayDenormalizer(),
                new JaneObjectNormalizer(),
            ],
            [
                new JsonEncoder(
                    new JsonEncode(),
                    new JsonDecode(['json_decode_associative' => true]),
                ),
            ],
        );
    }
}
