<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Factory\RequestContext;

use NoahVet\Reef\Factory\RequestContext\SortingApplier;
use PHPUnit\Framework\TestCase;
use Symfony\Component\HttpFoundation\Request;

class SortingApplierTest extends TestCase
{
    public function testApplyWithValidSortingKeys(): void
    {
        $sortingApplier = new SortingApplier();
        $request = new Request(['sortName' => 'ASC', 'sortDate' => 'DESC']);
        $whitelist = [
            'sorting' => ['sortName', 'sortDate'],
        ];

        $expected = [
            'sortName' => 'ASC',
            'sortDate' => 'DESC',
        ];

        $result = $sortingApplier->apply($request, $whitelist);
        $this->assertSame($expected, $result);
    }

    public function testApplyWithInvalidSortingKeys(): void
    {
        $sortingApplier = new SortingApplier();
        $request = new Request(['sortInvalid' => 'ASC', 'sortDate' => 'DESC']);
        $whitelist = [
            'sorting' => ['sortName', 'sortDate'],
        ];

        $expected = [
            'sortDate' => 'DESC',
        ];

        $result = $sortingApplier->apply($request, $whitelist);
        $this->assertSame($expected, $result);
    }

    public function testApplyWithNoSortingKeys(): void
    {
        $sortingApplier = new SortingApplier();
        $request = new Request([]);
        $whitelist = [
            'sorting' => ['sortName', 'sortDate'],
        ];

        $expected = [];

        $result = $sortingApplier->apply($request, $whitelist);
        $this->assertSame($expected, $result);
    }

    public function testApplyWithEmptyWhitelist(): void
    {
        $sortingApplier = new SortingApplier();
        $request = new Request(['sortName' => 'ASC', 'sortDate' => 'DESC']);
        $whitelist = [
            'sorting' => [],
        ];

        $expected = [];

        $result = $sortingApplier->apply($request, $whitelist);
        $this->assertSame($expected, $result);
    }

    public function testApplyWithMixedKeys(): void
    {
        $sortingApplier = new SortingApplier();
        $request = new Request([
            'sortName' => 'ASC',
            'sortInvalid' => 'DESC',
            'sortDate' => 'invalid_value',
        ]);
        $whitelist = [
            'sorting' => ['sortName', 'sortDate'],
        ];

        $expected = [
            'sortName' => 'ASC',
            'sortDate' => 'invalid_value',
        ];

        $result = $sortingApplier->apply($request, $whitelist);
        $this->assertSame($expected, $result);
    }
}
