<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Domain\Tool;

use NoahVet\Reef\Domain\Tool\VatTool;
use NoahVet\Reef\Domain\Tool\VatToolInterface;
use PHPUnit\Framework\TestCase;

final class VatToolTest extends TestCase
{
    private VatToolInterface $subject;

    protected function setUp(): void
    {
        $this->subject = new VatTool();
    }

    public function testAddVat(): void
    {
        // Add 20% vat on 100€
        $this->assertSame(
            12000,
            $this->subject->addVat(10000, 2000),
        );
    }

    public function testRemoveVat(): void
    {
        // Remove 20% vat on 120€
        $this->assertSame(
            10000,
            $this->subject->removeVat(12000, 2000),
        );
    }

    public function testGetVat(): void
    {
        $this->assertSame(
            2000,
            $this->subject->getVat(12000, 10000),
        );
    }

    public function testGetVatWithDecimal(): void
    {
        $this->assertSame(
            850,
            $this->subject->getVat(53165, 49000),
        );

        $this->assertSame(
            855,
            $this->subject->getVat(10855, 10000),
        );
    }

    public function testGetVatWhenAmountWithoutVatIsLowerThanZero(): void
    {
        $this->expectException(\InvalidArgumentException::class);
        $this->expectExceptionMessage('The `$amountWithoutVat` should be greater than 0.');
        $this->subject->getVat(0, 0);

        $this->expectException(\InvalidArgumentException::class);
        $this->expectExceptionMessage('The `$amountWithoutVat` should be greater than 0.');
        $this->subject->getVat(-2, -1);
    }

    public function testGetVatWhenAmountWithoutVatIsGreaterThanAmountWithVat(): void
    {
        $this->expectException(\InvalidArgumentException::class);
        $this->expectExceptionMessage('The `$amountWithVat` should be lower than or equals to `$amountWithVat`.');
        $this->subject->getVat(1000, 1300);
    }
}
