<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Domain\Comparator;

use NoahVet\Reef\Domain\Comparator\PrivilegedCodeComparator;
use NoahVet\Reef\Domain\Comparator\PrivilegedCodeComparatorInterface;
use PHPUnit\Framework\TestCase;

class PrivilegedComparatorTest extends TestCase
{
    private PrivilegedCodeComparatorInterface $subject;

    protected function setUp(): void
    {
        $this->subject = new PrivilegedCodeComparator();
    }

    public function testShouldNotContainABlacklistedWordWithGoodPrivilegedCode(): void
    {
        $privilegedCode = 'GRP001';

        self::assertTrue(
            $this->subject->shouldNotContainABlacklistedWord($privilegedCode),
        );
    }

    public function testShouldNotContainABlacklistedWordWithBlacklistedWord(): void
    {
        $privilegedCode = 'CUL001';

        self::assertFalse(
            $this->subject->shouldNotContainABlacklistedWord($privilegedCode),
        );
    }

    public function testShouldNotContainTheSameLetterTwiceConsecutivelyWithGoodPrivilegedCode(): void
    {
        $privilegedCode = 'GRP001';

        self::assertTrue(
            $this->subject->shouldNotContainTheSameLetterTwiceConsecutively($privilegedCode),
        );
    }

    public function testShouldNotContainTheSameLetterTwiceConsecutivelyWithBadPrivilegedCode(): void
    {
        $privilegedCode = 'GGP001';

        self::assertFalse(
            $this->subject->shouldNotContainTheSameLetterTwiceConsecutively($privilegedCode),
        );

        $privilegedCode = 'GGG001';

        self::assertFalse(
            $this->subject->shouldNotContainTheSameLetterTwiceConsecutively($privilegedCode),
        );

        $privilegedCode = 'PGG001';

        self::assertFalse(
            $this->subject->shouldNotContainTheSameLetterTwiceConsecutively($privilegedCode),
        );
    }
}
