<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Cache\Factory;

use NoahVet\Reef\Cache\Exception\CacheAdapterNotSupportedException;
use NoahVet\Reef\Cache\Factory\ReefCacheFactory;
use PHPUnit\Framework\TestCase;
use Psr\Cache\CacheItemPoolInterface;
use Symfony\Component\Cache\Adapter\ArrayAdapter;
use Symfony\Component\Cache\Adapter\NullAdapter;
use Symfony\Component\Cache\Adapter\RedisAdapter;

class ReefCacheFactoryTest extends TestCase
{
    private $redisUrl = 'redis://localhost';

    private $mockCachePools;

    protected function setUp(): void
    {
        $this->mockCachePools = [
            'cache.app' => $this->createMock(CacheItemPoolInterface::class),
            'someService' => $this->createMock(CacheItemPoolInterface::class),
        ];
    }

    public function testCreateCacheAdapterForArray(): void
    {
        $factory = new ReefCacheFactory($this->mockCachePools);
        $adapter = $factory->createCacheAdapter('array');
        $this->assertInstanceOf(ArrayAdapter::class, $adapter);
    }

    public function testCreateCacheAdapterForNull(): void
    {
        $factory = new ReefCacheFactory($this->mockCachePools);
        $adapter = $factory->createCacheAdapter('null');
        $this->assertInstanceOf(NullAdapter::class, $adapter);
    }

    public function testCreateCacheAdapterForRedis(): void
    {
        $factory = new ReefCacheFactory($this->mockCachePools);
        $adapter = $factory->createCacheAdapter($this->redisUrl);
        $this->assertInstanceOf(RedisAdapter::class, $adapter);
    }

    public function testCreateCacheAdapterForService(): void
    {
        $factory = new ReefCacheFactory($this->mockCachePools);
        $adapter = $factory->createCacheAdapter('service://someService');
        $this->assertSame($this->mockCachePools['someService'], $adapter);
    }

    public function testCreateCacheAdapterThrowsExceptionForUnknownAdapter(): void
    {
        $this->expectException(CacheAdapterNotSupportedException::class);
        $factory = new ReefCacheFactory($this->mockCachePools);
        $factory->createCacheAdapter('unknown://');
    }
}
