<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Business\Model\Factory;

use NoahVet\Reef\Business\Model\Factory\TeamMemberFactory;
use NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserResponse;
use NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserResponseUser;
use NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserResponseVeterinaryEstablishment;
use PHPUnit\Framework\TestCase;

class TeamMemberFactoryTest extends TestCase
{
    public function testCreate(): void
    {
        $teamMember = new VeterinaryEstablishmentUserResponse();
        $teamMemberEst = new VeterinaryEstablishmentUserResponseVeterinaryEstablishment();
        $teamMemberEst->setId('phpunit-establishment-id');
        $teamMember->setVeterinaryEstablishment($teamMemberEst);
        $teamMemberUser = new VeterinaryEstablishmentUserResponseUser();
        $teamMemberUser->setId('user-id');
        $teamMember->setUser($teamMemberUser);
        $teamMember->setJobTitle('jobtitle');
        $teamMember->setEntryDate(new \DateTime('-5 days'));
        $teamMember->setExitDate(new \DateTime('+5 days'));

        $factory = new TeamMemberFactory();

        $tm = $factory->create($teamMember);
        self::assertEquals('user-id', $tm->getUuid());
        self::assertEquals('jobtitle', $tm->getJobTitle());
        self::assertEquals($teamMember->getEntryDate(), $tm->getEntryDate());
        self::assertEquals($teamMember->getExitDate(), $tm->getExitDate());
    }
}
