<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Business\Enumerator;

use NoahVet\Reef\Business\Enumerator\VeterinaryEstablishmentEnumerator;
use NoahVet\Reef\Jane\Client;
use NoahVet\Reef\Jane\Model\VeterinaryEstablishmentResponse;
use PHPUnit\Framework\TestCase;
use Psr\Http\Client\NetworkExceptionInterface;

class VeterinaryEstablishmentEnumeratorTest extends TestCase
{
    public function testEnumerateApiDown(): void
    {
        $client = $this->getMockBuilder(Client::class)
            ->disableOriginalConstructor()
            ->getMock()
        ;

        $client
            ->method('getAllVeterinaryEstablishment')
            ->withAnyParameters()
            ->willThrowException(
                $this
                    ->getMockBuilder(NetworkExceptionInterface::class)
                    ->disableOriginalConstructor()
                    ->getMock(),
            )
        ;

        $enumerator = new VeterinaryEstablishmentEnumerator($client);

        self::expectException(NetworkExceptionInterface::class);

        \iterator_to_array($enumerator->enumerateAll());
    }

    public function testEnumerateAll(): void
    {
        $client = $this->getMockBuilder(Client::class)
            ->disableOriginalConstructor()
            ->getMock()
        ;

        $establishment = new VeterinaryEstablishmentResponse();

        $client
            ->expects(self::exactly(1))
            ->method('getAllVeterinaryEstablishment')
            ->withConsecutive(
                [['page' => 0, 'limit' => 50]],
            )
            ->willReturnOnConsecutiveCalls(
                [$establishment],
            )
        ;

        $enumerator = new VeterinaryEstablishmentEnumerator($client);

        $establishments = \iterator_to_array($enumerator->enumerateAll());
        self::assertCount(1, $establishments);
        self::assertSame($establishment, $establishments[0]);
    }
}
