<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Business\Enumerator;

use NoahVet\Reef\Business\Enumerator\ManufacturerEnumerator;
use NoahVet\Reef\Business\Enumerator\ManufacturerWithTeamEnumerator;
use NoahVet\Reef\Business\Model\Factory\ManufacturerWithTeamFactory;
use NoahVet\Reef\Business\Model\ManufacturerWithTeam;
use NoahVet\Reef\Business\Model\TeamMember;
use NoahVet\Reef\Jane\Model\ManufacturerResponseItem;
use PHPUnit\Framework\TestCase;

class ManufacturerWithTeamEnumeratorTest extends TestCase
{
    public function testEnumerateAll(): void
    {
        $manufacturer = new ManufacturerResponseItem();
        $manufacturer->setId('phpunit-manufacturer-id');

        $teamMember = new TeamMember(
            'user-id',
            'jobtitle',
            null,
            null,
        );
        $manufacturerWithTeam = new ManufacturerWithTeam(
            'phpunit-manufacturer-id',
            'aaa000',
            [
                $teamMember,
            ],
        );

        $manufacturerEnumerator = $this->getMockBuilder(ManufacturerEnumerator::class)
            ->disableOriginalConstructor()
            ->getMock()
        ;

        $manufacturerEnumerator
            ->expects($this->once())
            ->method('enumerateAll')
            ->willReturnCallback(
                function () use ($manufacturer) {
                    yield $manufacturer;
                },
            )
        ;

        $manufacturerWithTeamFactory = $this->getMockBuilder(ManufacturerWithTeamFactory::class)
            ->disableOriginalConstructor()
            ->getMock()
        ;

        $manufacturerWithTeamFactory
            ->expects($this->once())
            ->method('createBatch')
            ->with([$manufacturer])
            ->willReturn([$manufacturerWithTeam])
        ;

        $enumerator = new ManufacturerWithTeamEnumerator(
            $manufacturerEnumerator,
            $manufacturerWithTeamFactory,
        );

        $manufacturers = \iterator_to_array($enumerator->enumerateAll());

        self::assertCount(1, $manufacturers);
        self::assertSame($manufacturerWithTeam, $manufacturers[0]);
    }
}
