<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Business\Enumerator;

use NoahVet\Reef\Business\Enumerator\EstablishmentWithTeamEnumerator;
use NoahVet\Reef\Business\Enumerator\VeterinaryEstablishmentEnumerator;
use NoahVet\Reef\Business\Model\EstablishmentWithTeam;
use NoahVet\Reef\Business\Model\Factory\EstablishmentWithTeamFactory;
use NoahVet\Reef\Business\Model\TeamMember;
use PHPUnit\Framework\TestCase;

class EstablishmentWithTeamEnumeratorTest extends TestCase
{
    public function testEnumerateAll(): void
    {
        $establishment = new \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserResponse();
        $establishment->setId('phpunit-establishment-id');

        $teamMember = new TeamMember(
            'user-id',
            'jobtitle',
            null,
            null,
        );
        $establishmentWithTeam = new EstablishmentWithTeam(
            'phpunit-establishment-id',
            'aaa000',
            [
                $teamMember,
            ],
        );

        $establishmentEnumerator = $this->getMockBuilder(VeterinaryEstablishmentEnumerator::class)
            ->disableOriginalConstructor()
            ->getMock()
        ;

        $establishmentEnumerator
            ->expects($this->once())
            ->method('enumerateAll')
            ->willReturnCallback(
                function () use ($establishment) {
                    yield $establishment;
                },
            )
        ;

        $establishmentWithTeamFactory = $this->getMockBuilder(EstablishmentWithTeamFactory::class)
            ->disableOriginalConstructor()
            ->getMock()
        ;

        $establishmentWithTeamFactory
            ->expects($this->once())
            ->method('createBatch')
            ->with([$establishment])
            ->willReturn([$establishmentWithTeam])
        ;

        $enumerator = new EstablishmentWithTeamEnumerator(
            $establishmentEnumerator,
            $establishmentWithTeamFactory,
        );

        $establishments = \iterator_to_array($enumerator->enumerateAll());

        self::assertCount(1, $establishments);
        self::assertSame($establishmentWithTeam, $establishments[0]);
    }
}
