<?php

declare(strict_types=1);

namespace NoahVet\Reef\Security\Policy;

/**
 * @template T of PolicySubjectInterface
 */
interface PolicyInterface
{
    public function getName(): string;

    /**
     * @param T $subject
     */
    public function subjectToString(PolicySubjectInterface $subject): string;

    /**
     * @param T $subject
     */
    public function computeEtag(PolicySubjectInterface $subject): string;

    /**
     * @param T $subject
     */
    public function apply(PolicySubjectInterface $subject): PolicyResult;

    public function canHandle(PolicySubjectInterface $subject): bool;
}
