<?php

declare(strict_types=1);

namespace NoahVet\Reef\Security\IAM\Model;

class ResourceGroupWithMembers extends ResourceGroup
{
    /**
     * @param \NoahVet\Reef\Security\IAM\Model\Resource[] $members
     */
    public function __construct(
        ResourceType $resourceType,
        string $groupId,
        protected array $members,
    ) {
        parent::__construct($resourceType, $groupId);
    }

    /**
     * @param string[] $members
     */
    public static function fromStringWithMembers(
        ResourceType|string $resourceType,
        mixed $groupId,
        array $members,
    ): self {
        return new self(
            \is_string($resourceType) ? ResourceType::fromString($resourceType) : $resourceType,
            (string) $groupId,
            \array_map(
                fn (string $member) => Resource::fromString($resourceType, $member),
                $members,
            ),
        );
    }

    /**
     * @return \NoahVet\Reef\Security\IAM\Model\Resource[]
     */
    public function getMembers(): array
    {
        return $this->members;
    }
}
