<?php

declare(strict_types=1);

namespace NoahVet\Reef\Security\IAM\Finder;

class ResourceIterator
{
    /**
     * @var iterable<ResourceFinderInterface>
     */
    protected iterable $iterators;

    /**
     * @param iterable<ResourceFinderInterface> $iterators
     */
    public function __construct(
        iterable $iterators,
    ) {
        $this->iterators = $iterators;
    }

    /**
     * @return \Generator<mixed>
     */
    public function iterate(): \Generator
    {
        foreach ($this->iterators as $iterator) {
            if (!$iterator instanceof ResourceFinderEnumeratorInterface) {
                continue;
            }

            foreach ($iterator->enumerate() as $item) {
                yield $item;
            }
        }
    }
}
