<?php

declare(strict_types=1);

namespace NoahVet\Reef\RabbitMQ\Task\Facade;

use NoahVet\Reef\RabbitMQ\Task\Factory\ConsoleCommandTaskFactoryInterface;
use NoahVet\Reef\RabbitMQ\Task\Sender\ReefTaskSenderInterface;
use Symfony\Component\Console\Command\Command;

class ReefTaskSenderFacade implements ReefTaskSenderFacadeInterface
{
    public function __construct(
        private readonly ReefTaskSenderInterface $reefTaskSender,
        private readonly ConsoleCommandTaskFactoryInterface $commandTaskFactory,
    ) {
    }

    public function sendConsoleCommandTask(
        Command $command,
        array $arguments,
    ): void {
        $this->reefTaskSender->sendTask(
            $this->commandTaskFactory->create($command, $arguments),
        );
    }
}
