<?php

declare(strict_types=1);

namespace NoahVet\Reef\RabbitMQ\Notification\Factory;

use NoahVet\Reef\RabbitMQ\Notification\ReefNotificationInterface;
use NoahVet\Reef\Security\IAM\Model\Resource;

interface ReefNotificationFactoryInterface
{
    /**
     * @param array<string, string|int|float|bool|array<string, string|int|float|bool>> $rawData
     */
    public function createNotification(
        Resource $resource,
        string $action,
        array $rawData,
    ): ReefNotificationInterface;
}
