<?php

declare(strict_types=1);

namespace NoahVet\Reef\Phpunit\Iterator;

use NoahVet\Reef\Iterator\ReefApiIteratorInterface;

/**
 * @template TValue of object
 *
 * @implements ReefApiIteratorInterface<TValue, array<string, mixed>>
 */
class MockedReefApiIterator implements ReefApiIteratorInterface
{
    /**
     * @param \ArrayIterator<int, TValue> $items
     * @param array<string, mixed>        $params
     */
    public function __construct(
        private readonly \ArrayIterator $items,
        private array $params,
    ) {
    }

    public function getParams(): array
    {
        return $this->params;
    }

    public function setParams(array $params): void
    {
        $this->params = $params;
    }

    public function current(): mixed
    {
        return $this->items->current();
    }

    public function next(): void
    {
        $this->items->next();
    }

    public function key(): mixed
    {
        return $this->items->key();
    }

    public function valid(): bool
    {
        return $this->items->valid();
    }

    public function rewind(): void
    {
        $this->items->rewind();
    }
}
