<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class WebOrderProductResponseNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []): bool
    {
        return \NoahVet\Reef\Jane\Model\WebOrderProductResponse::class === $type;
    }

    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []): bool
    {
        return \is_object($data) && \NoahVet\Reef\Jane\Model\WebOrderProductResponse::class === $data::class;
    }

    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []): mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\WebOrderProductResponse();
        if (\array_key_exists('unitPrice', $data) && \is_int($data['unitPrice'])) {
            $data['unitPrice'] = (float) $data['unitPrice'];
        }
        if (\array_key_exists('totalPrice', $data) && \is_int($data['totalPrice'])) {
            $data['totalPrice'] = (float) $data['totalPrice'];
        }
        if (\array_key_exists('valuedTotalPrice', $data) && \is_int($data['valuedTotalPrice'])) {
            $data['valuedTotalPrice'] = (float) $data['valuedTotalPrice'];
        }
        if (\array_key_exists('payRate', $data) && \is_int($data['payRate'])) {
            $data['payRate'] = (float) $data['payRate'];
        }
        if (\array_key_exists('paying', $data) && \is_int($data['paying'])) {
            $data['paying'] = (float) $data['paying'];
        }
        if (\array_key_exists('yearEndDiscountRate', $data) && \is_int($data['yearEndDiscountRate'])) {
            $data['yearEndDiscountRate'] = (float) $data['yearEndDiscountRate'];
        }
        if (\array_key_exists('yearEndDiscount', $data) && \is_int($data['yearEndDiscount'])) {
            $data['yearEndDiscount'] = (float) $data['yearEndDiscount'];
        }
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('mvsId', $data)) {
            $object->setMvsId($data['mvsId']);
            unset($data['mvsId']);
        }
        if (\array_key_exists('gtin', $data)) {
            $object->setGtin($data['gtin']);
            unset($data['gtin']);
        }
        if (\array_key_exists('supplierCode', $data)) {
            $object->setSupplierCode($data['supplierCode']);
            unset($data['supplierCode']);
        }
        if (\array_key_exists('name', $data)) {
            $object->setName($data['name']);
            unset($data['name']);
        }
        if (\array_key_exists('format', $data)) {
            $object->setFormat($data['format']);
            unset($data['format']);
        }
        if (\array_key_exists('category', $data)) {
            $object->setCategory($data['category']);
            unset($data['category']);
        }
        if (\array_key_exists('manufacturer', $data)) {
            $object->setManufacturer($data['manufacturer']);
            unset($data['manufacturer']);
        }
        if (\array_key_exists('quantity', $data)) {
            $object->setQuantity($data['quantity']);
            unset($data['quantity']);
        }
        if (\array_key_exists('unitPrice', $data)) {
            $object->setUnitPrice($data['unitPrice']);
            unset($data['unitPrice']);
        }
        if (\array_key_exists('totalPrice', $data)) {
            $object->setTotalPrice($data['totalPrice']);
            unset($data['totalPrice']);
        }
        if (\array_key_exists('valuedTotalPrice', $data)) {
            $object->setValuedTotalPrice($data['valuedTotalPrice']);
            unset($data['valuedTotalPrice']);
        }
        if (\array_key_exists('payRate', $data)) {
            $object->setPayRate($data['payRate']);
            unset($data['payRate']);
        }
        if (\array_key_exists('paying', $data)) {
            $object->setPaying($data['paying']);
            unset($data['paying']);
        }
        if (\array_key_exists('yearEndDiscountRate', $data)) {
            $object->setYearEndDiscountRate($data['yearEndDiscountRate']);
            unset($data['yearEndDiscountRate']);
        }
        if (\array_key_exists('yearEndDiscount', $data)) {
            $object->setYearEndDiscount($data['yearEndDiscount']);
            unset($data['yearEndDiscount']);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    public function normalize(mixed $data, ?string $format = null, array $context = []): array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('id') && null !== $data->getId()) {
            $dataArray['id'] = $data->getId();
        }
        if ($data->isInitialized('mvsId') && null !== $data->getMvsId()) {
            $dataArray['mvsId'] = $data->getMvsId();
        }
        if ($data->isInitialized('gtin') && null !== $data->getGtin()) {
            $dataArray['gtin'] = $data->getGtin();
        }
        if ($data->isInitialized('supplierCode') && null !== $data->getSupplierCode()) {
            $dataArray['supplierCode'] = $data->getSupplierCode();
        }
        if ($data->isInitialized('name') && null !== $data->getName()) {
            $dataArray['name'] = $data->getName();
        }
        if ($data->isInitialized('format') && null !== $data->getFormat()) {
            $dataArray['format'] = $data->getFormat();
        }
        if ($data->isInitialized('category') && null !== $data->getCategory()) {
            $dataArray['category'] = $data->getCategory();
        }
        if ($data->isInitialized('manufacturer') && null !== $data->getManufacturer()) {
            $dataArray['manufacturer'] = $data->getManufacturer();
        }
        if ($data->isInitialized('quantity') && null !== $data->getQuantity()) {
            $dataArray['quantity'] = $data->getQuantity();
        }
        if ($data->isInitialized('unitPrice') && null !== $data->getUnitPrice()) {
            $dataArray['unitPrice'] = $data->getUnitPrice();
        }
        if ($data->isInitialized('totalPrice') && null !== $data->getTotalPrice()) {
            $dataArray['totalPrice'] = $data->getTotalPrice();
        }
        if ($data->isInitialized('valuedTotalPrice') && null !== $data->getValuedTotalPrice()) {
            $dataArray['valuedTotalPrice'] = $data->getValuedTotalPrice();
        }
        if ($data->isInitialized('payRate') && null !== $data->getPayRate()) {
            $dataArray['payRate'] = $data->getPayRate();
        }
        if ($data->isInitialized('paying') && null !== $data->getPaying()) {
            $dataArray['paying'] = $data->getPaying();
        }
        if ($data->isInitialized('yearEndDiscountRate') && null !== $data->getYearEndDiscountRate()) {
            $dataArray['yearEndDiscountRate'] = $data->getYearEndDiscountRate();
        }
        if ($data->isInitialized('yearEndDiscount') && null !== $data->getYearEndDiscount()) {
            $dataArray['yearEndDiscount'] = $data->getYearEndDiscount();
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }

        return $dataArray;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return [\NoahVet\Reef\Jane\Model\WebOrderProductResponse::class => false];
    }
}
