<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class WebOrderPaymentResponseNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []): bool
    {
        return \NoahVet\Reef\Jane\Model\WebOrderPaymentResponse::class === $type;
    }

    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []): bool
    {
        return \is_object($data) && \NoahVet\Reef\Jane\Model\WebOrderPaymentResponse::class === $data::class;
    }

    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []): mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\WebOrderPaymentResponse();
        if (\array_key_exists('amount', $data) && \is_int($data['amount'])) {
            $data['amount'] = (float) $data['amount'];
        }
        if (\array_key_exists('bankFeeFix', $data) && \is_int($data['bankFeeFix'])) {
            $data['bankFeeFix'] = (float) $data['bankFeeFix'];
        }
        if (\array_key_exists('bankFeeRate', $data) && \is_int($data['bankFeeRate'])) {
            $data['bankFeeRate'] = (float) $data['bankFeeRate'];
        }
        if (\array_key_exists('bankFee', $data) && \is_int($data['bankFee'])) {
            $data['bankFee'] = (float) $data['bankFee'];
        }
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('mvsId', $data)) {
            $object->setMvsId($data['mvsId']);
            unset($data['mvsId']);
        }
        if (\array_key_exists('platform', $data)) {
            $object->setPlatform($data['platform']);
            unset($data['platform']);
        }
        if (\array_key_exists('amount', $data)) {
            $object->setAmount($data['amount']);
            unset($data['amount']);
        }
        if (\array_key_exists('bankFeeFix', $data)) {
            $object->setBankFeeFix($data['bankFeeFix']);
            unset($data['bankFeeFix']);
        }
        if (\array_key_exists('bankFeeRate', $data)) {
            $object->setBankFeeRate($data['bankFeeRate']);
            unset($data['bankFeeRate']);
        }
        if (\array_key_exists('bankFee', $data)) {
            $object->setBankFee($data['bankFee']);
            unset($data['bankFee']);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    public function normalize(mixed $data, ?string $format = null, array $context = []): array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('id') && null !== $data->getId()) {
            $dataArray['id'] = $data->getId();
        }
        if ($data->isInitialized('mvsId') && null !== $data->getMvsId()) {
            $dataArray['mvsId'] = $data->getMvsId();
        }
        if ($data->isInitialized('platform') && null !== $data->getPlatform()) {
            $dataArray['platform'] = $data->getPlatform();
        }
        if ($data->isInitialized('amount') && null !== $data->getAmount()) {
            $dataArray['amount'] = $data->getAmount();
        }
        if ($data->isInitialized('bankFeeFix') && null !== $data->getBankFeeFix()) {
            $dataArray['bankFeeFix'] = $data->getBankFeeFix();
        }
        if ($data->isInitialized('bankFeeRate') && null !== $data->getBankFeeRate()) {
            $dataArray['bankFeeRate'] = $data->getBankFeeRate();
        }
        if ($data->isInitialized('bankFee') && null !== $data->getBankFee()) {
            $dataArray['bankFee'] = $data->getBankFee();
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }

        return $dataArray;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return [\NoahVet\Reef\Jane\Model\WebOrderPaymentResponse::class => false];
    }
}
