<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class VeterinaryEstablishmentUserResponseNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []): bool
    {
        return \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserResponse::class === $type;
    }

    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []): bool
    {
        return \is_object($data) && \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserResponse::class === $data::class;
    }

    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []): mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserResponse();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('createdDate', $data)) {
            $object->setCreatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['createdDate']));
            unset($data['createdDate']);
        }
        if (\array_key_exists('updatedDate', $data)) {
            $object->setUpdatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updatedDate']));
            unset($data['updatedDate']);
        }
        if (\array_key_exists('departments', $data)) {
            $values = [];
            foreach ($data['departments'] as $value) {
                $values[] = $value;
            }
            $object->setDepartments($values);
            unset($data['departments']);
        }
        if (\array_key_exists('entryDate', $data) && null !== $data['entryDate']) {
            $object->setEntryDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['entryDate']));
            unset($data['entryDate']);
        } elseif (\array_key_exists('entryDate', $data) && null === $data['entryDate']) {
            $object->setEntryDate(null);
        }
        if (\array_key_exists('exitDate', $data) && null !== $data['exitDate']) {
            $object->setExitDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['exitDate']));
            unset($data['exitDate']);
        } elseif (\array_key_exists('exitDate', $data) && null === $data['exitDate']) {
            $object->setExitDate(null);
        }
        if (\array_key_exists('jobTitle', $data)) {
            $object->setJobTitle($data['jobTitle']);
            unset($data['jobTitle']);
        }
        if (\array_key_exists('user', $data) && null !== $data['user']) {
            $object->setUser($this->denormalizer->denormalize($data['user'], \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserResponseUser::class, 'json', $context));
            unset($data['user']);
        } elseif (\array_key_exists('user', $data) && null === $data['user']) {
            $object->setUser(null);
        }
        if (\array_key_exists('veterinaryEstablishment', $data) && null !== $data['veterinaryEstablishment']) {
            $object->setVeterinaryEstablishment($this->denormalizer->denormalize($data['veterinaryEstablishment'], \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserResponseVeterinaryEstablishment::class, 'json', $context));
            unset($data['veterinaryEstablishment']);
        } elseif (\array_key_exists('veterinaryEstablishment', $data) && null === $data['veterinaryEstablishment']) {
            $object->setVeterinaryEstablishment(null);
        }
        foreach ($data as $key => $value_1) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_1;
            }
        }

        return $object;
    }

    public function normalize(mixed $data, ?string $format = null, array $context = []): array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        $dataArray['id'] = $data->getId();
        $dataArray['createdDate'] = $data->getCreatedDate()?->format('Y-m-d\\TH:i:sP');
        $dataArray['updatedDate'] = $data->getUpdatedDate()?->format('Y-m-d\\TH:i:sP');
        $values = [];
        foreach ($data->getDepartments() as $value) {
            $values[] = $value;
        }
        $dataArray['departments'] = $values;
        if ($data->isInitialized('entryDate') && null !== $data->getEntryDate()) {
            $dataArray['entryDate'] = $data->getEntryDate()->format('Y-m-d\\TH:i:sP');
        }
        if ($data->isInitialized('exitDate') && null !== $data->getExitDate()) {
            $dataArray['exitDate'] = $data->getExitDate()->format('Y-m-d\\TH:i:sP');
        }
        $dataArray['jobTitle'] = $data->getJobTitle();
        $dataArray['user'] = $this->normalizer->normalize($data->getUser(), 'json', $context);
        $dataArray['veterinaryEstablishment'] = $this->normalizer->normalize($data->getVeterinaryEstablishment(), 'json', $context);
        foreach ($data as $key => $value_1) {
            if (\preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value_1;
            }
        }

        return $dataArray;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return [\NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserResponse::class => false];
    }
}
