<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class V1PetBreedExternalRefsGetResponse200ItemCoveredLocalesNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []): bool
    {
        return \NoahVet\Reef\Jane\Model\V1PetBreedExternalRefsGetResponse200ItemCoveredLocales::class === $type;
    }

    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []): bool
    {
        return \is_object($data) && \NoahVet\Reef\Jane\Model\V1PetBreedExternalRefsGetResponse200ItemCoveredLocales::class === $data::class;
    }

    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []): mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\V1PetBreedExternalRefsGetResponse200ItemCoveredLocales();
        if (\array_key_exists('en_GB', $data) && \is_int($data['en_GB'])) {
            $data['en_GB'] = (bool) $data['en_GB'];
        }
        if (\array_key_exists('fr_FR', $data) && \is_int($data['fr_FR'])) {
            $data['fr_FR'] = (bool) $data['fr_FR'];
        }
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('en_GB', $data)) {
            $object->setEnGB($data['en_GB']);
            unset($data['en_GB']);
        }
        if (\array_key_exists('fr_FR', $data)) {
            $object->setFrFR($data['fr_FR']);
            unset($data['fr_FR']);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    public function normalize(mixed $data, ?string $format = null, array $context = []): array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('enGB') && null !== $data->getEnGB()) {
            $dataArray['en_GB'] = $data->getEnGB();
        }
        if ($data->isInitialized('frFR') && null !== $data->getFrFR()) {
            $dataArray['fr_FR'] = $data->getFrFR();
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }

        return $dataArray;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return [\NoahVet\Reef\Jane\Model\V1PetBreedExternalRefsGetResponse200ItemCoveredLocales::class => false];
    }
}
