<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class V1CustomerProfilesIdPatchResponse200Normalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []): bool
    {
        return \NoahVet\Reef\Jane\Model\V1CustomerProfilesIdPatchResponse200::class === $type;
    }

    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []): bool
    {
        return \is_object($data) && \NoahVet\Reef\Jane\Model\V1CustomerProfilesIdPatchResponse200::class === $data::class;
    }

    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []): mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\V1CustomerProfilesIdPatchResponse200();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('createdDate', $data)) {
            $object->setCreatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['createdDate']));
            unset($data['createdDate']);
        }
        if (\array_key_exists('updatedDate', $data)) {
            $object->setUpdatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updatedDate']));
            unset($data['updatedDate']);
        }
        if (\array_key_exists('billingContact', $data) && null !== $data['billingContact']) {
            $object->setBillingContact($this->denormalizer->denormalize($data['billingContact'], \NoahVet\Reef\Jane\Model\V1CustomerProfilesIdPatchResponse200BillingContact::class, 'json', $context));
            unset($data['billingContact']);
        } elseif (\array_key_exists('billingContact', $data) && null === $data['billingContact']) {
            $object->setBillingContact(null);
        }
        if (\array_key_exists('birthDate', $data) && null !== $data['birthDate']) {
            $object->setBirthDate(\DateTime::createFromFormat('Y-m-d', $data['birthDate'])->setTime(0, 0, 0));
            unset($data['birthDate']);
        } elseif (\array_key_exists('birthDate', $data) && null === $data['birthDate']) {
            $object->setBirthDate(null);
        }
        if (\array_key_exists('birthName', $data) && null !== $data['birthName']) {
            $object->setBirthName($data['birthName']);
            unset($data['birthName']);
        } elseif (\array_key_exists('birthName', $data) && null === $data['birthName']) {
            $object->setBirthName(null);
        }
        if (\array_key_exists('companyDescription', $data) && null !== $data['companyDescription']) {
            $object->setCompanyDescription($data['companyDescription']);
            unset($data['companyDescription']);
        } elseif (\array_key_exists('companyDescription', $data) && null === $data['companyDescription']) {
            $object->setCompanyDescription(null);
        }
        if (\array_key_exists('customer', $data)) {
            $object->setCustomer($this->denormalizer->denormalize($data['customer'], \NoahVet\Reef\Jane\Model\V1CustomerProfilesIdPatchResponse200Customer::class, 'json', $context));
            unset($data['customer']);
        }
        if (\array_key_exists('deliveryContact', $data) && null !== $data['deliveryContact']) {
            $object->setDeliveryContact($this->denormalizer->denormalize($data['deliveryContact'], \NoahVet\Reef\Jane\Model\V1CustomerProfilesIdPatchResponse200DeliveryContact::class, 'json', $context));
            unset($data['deliveryContact']);
        } elseif (\array_key_exists('deliveryContact', $data) && null === $data['deliveryContact']) {
            $object->setDeliveryContact(null);
        }
        if (\array_key_exists('firstname', $data) && null !== $data['firstname']) {
            $object->setFirstname($data['firstname']);
            unset($data['firstname']);
        } elseif (\array_key_exists('firstname', $data) && null === $data['firstname']) {
            $object->setFirstname(null);
        }
        if (\array_key_exists('gender', $data) && null !== $data['gender']) {
            $object->setGender($data['gender']);
            unset($data['gender']);
        } elseif (\array_key_exists('gender', $data) && null === $data['gender']) {
            $object->setGender(null);
        }
        if (\array_key_exists('lastname', $data) && null !== $data['lastname']) {
            $object->setLastname($data['lastname']);
            unset($data['lastname']);
        } elseif (\array_key_exists('lastname', $data) && null === $data['lastname']) {
            $object->setLastname(null);
        }
        if (\array_key_exists('mainContact', $data) && null !== $data['mainContact']) {
            $object->setMainContact($this->denormalizer->denormalize($data['mainContact'], \NoahVet\Reef\Jane\Model\V1CustomerProfilesIdPatchResponse200MainContact::class, 'json', $context));
            unset($data['mainContact']);
        } elseif (\array_key_exists('mainContact', $data) && null === $data['mainContact']) {
            $object->setMainContact(null);
        }
        if (\array_key_exists('source', $data)) {
            $object->setSource($data['source']);
            unset($data['source']);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    public function normalize(mixed $data, ?string $format = null, array $context = []): array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        $dataArray['id'] = $data->getId();
        $dataArray['createdDate'] = $data->getCreatedDate()?->format('Y-m-d\\TH:i:sP');
        $dataArray['updatedDate'] = $data->getUpdatedDate()?->format('Y-m-d\\TH:i:sP');
        $dataArray['billingContact'] = $this->normalizer->normalize($data->getBillingContact(), 'json', $context);
        $dataArray['birthDate'] = $data->getBirthDate()->format('Y-m-d');
        $dataArray['birthName'] = $data->getBirthName();
        $dataArray['companyDescription'] = $data->getCompanyDescription();
        $dataArray['customer'] = $this->normalizer->normalize($data->getCustomer(), 'json', $context);
        $dataArray['deliveryContact'] = $this->normalizer->normalize($data->getDeliveryContact(), 'json', $context);
        $dataArray['firstname'] = $data->getFirstname();
        $dataArray['gender'] = $data->getGender();
        $dataArray['lastname'] = $data->getLastname();
        $dataArray['mainContact'] = $this->normalizer->normalize($data->getMainContact(), 'json', $context);
        $dataArray['source'] = $data->getSource();
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }

        return $dataArray;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return [\NoahVet\Reef\Jane\Model\V1CustomerProfilesIdPatchResponse200::class => false];
    }
}
