<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class SchemasVeterinaryEstablishmentServiceDeliveryRequestNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []): bool
    {
        return \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentServiceDeliveryRequest::class === $type;
    }

    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []): bool
    {
        return \is_object($data) && \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentServiceDeliveryRequest::class === $data::class;
    }

    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []): mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentServiceDeliveryRequest();
        if (\array_key_exists('shouldGenerateInvoice', $data) && \is_int($data['shouldGenerateInvoice'])) {
            $data['shouldGenerateInvoice'] = (bool) $data['shouldGenerateInvoice'];
        }
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('accountingCode', $data) && null !== $data['accountingCode']) {
            $object->setAccountingCode($data['accountingCode']);
            unset($data['accountingCode']);
        } elseif (\array_key_exists('accountingCode', $data) && null === $data['accountingCode']) {
            $object->setAccountingCode(null);
        }
        if (\array_key_exists('completionDate', $data) && null !== $data['completionDate']) {
            $object->setCompletionDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['completionDate']));
            unset($data['completionDate']);
        } elseif (\array_key_exists('completionDate', $data) && null === $data['completionDate']) {
            $object->setCompletionDate(null);
        }
        if (\array_key_exists('internalCommentary', $data) && null !== $data['internalCommentary']) {
            $object->setInternalCommentary($data['internalCommentary']);
            unset($data['internalCommentary']);
        } elseif (\array_key_exists('internalCommentary', $data) && null === $data['internalCommentary']) {
            $object->setInternalCommentary(null);
        }
        if (\array_key_exists('invoiceDate', $data) && null !== $data['invoiceDate']) {
            $object->setInvoiceDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['invoiceDate']));
            unset($data['invoiceDate']);
        } elseif (\array_key_exists('invoiceDate', $data) && null === $data['invoiceDate']) {
            $object->setInvoiceDate(null);
        }
        if (\array_key_exists('longDescription', $data) && null !== $data['longDescription']) {
            $object->setLongDescription($data['longDescription']);
            unset($data['longDescription']);
        } elseif (\array_key_exists('longDescription', $data) && null === $data['longDescription']) {
            $object->setLongDescription(null);
        }
        if (\array_key_exists('paymentMethod', $data) && null !== $data['paymentMethod']) {
            $object->setPaymentMethod($data['paymentMethod']);
            unset($data['paymentMethod']);
        } elseif (\array_key_exists('paymentMethod', $data) && null === $data['paymentMethod']) {
            $object->setPaymentMethod(null);
        }
        if (\array_key_exists('shouldGenerateInvoice', $data) && null !== $data['shouldGenerateInvoice']) {
            $object->setShouldGenerateInvoice($data['shouldGenerateInvoice']);
            unset($data['shouldGenerateInvoice']);
        } elseif (\array_key_exists('shouldGenerateInvoice', $data) && null === $data['shouldGenerateInvoice']) {
            $object->setShouldGenerateInvoice(null);
        }
        if (\array_key_exists('specificBillingAccount', $data) && null !== $data['specificBillingAccount']) {
            $object->setSpecificBillingAccount($this->denormalizer->denormalize($data['specificBillingAccount'], \NoahVet\Reef\Jane\Model\NullableIdRequest::class, 'json', $context));
            unset($data['specificBillingAccount']);
        } elseif (\array_key_exists('specificBillingAccount', $data) && null === $data['specificBillingAccount']) {
            $object->setSpecificBillingAccount(null);
        }
        if (\array_key_exists('specificVeterinaryGroup', $data) && null !== $data['specificVeterinaryGroup']) {
            $object->setSpecificVeterinaryGroup($this->denormalizer->denormalize($data['specificVeterinaryGroup'], \NoahVet\Reef\Jane\Model\NullableIdRequest::class, 'json', $context));
            unset($data['specificVeterinaryGroup']);
        } elseif (\array_key_exists('specificVeterinaryGroup', $data) && null === $data['specificVeterinaryGroup']) {
            $object->setSpecificVeterinaryGroup(null);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    public function normalize(mixed $data, ?string $format = null, array $context = []): array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('accountingCode') && null !== $data->getAccountingCode()) {
            $dataArray['accountingCode'] = $data->getAccountingCode();
        }
        if ($data->isInitialized('completionDate') && null !== $data->getCompletionDate()) {
            $dataArray['completionDate'] = $data->getCompletionDate()->format('Y-m-d\\TH:i:sP');
        }
        if ($data->isInitialized('internalCommentary') && null !== $data->getInternalCommentary()) {
            $dataArray['internalCommentary'] = $data->getInternalCommentary();
        }
        if ($data->isInitialized('invoiceDate') && null !== $data->getInvoiceDate()) {
            $dataArray['invoiceDate'] = $data->getInvoiceDate()->format('Y-m-d\\TH:i:sP');
        }
        if ($data->isInitialized('longDescription') && null !== $data->getLongDescription()) {
            $dataArray['longDescription'] = $data->getLongDescription();
        }
        if ($data->isInitialized('paymentMethod') && null !== $data->getPaymentMethod()) {
            $dataArray['paymentMethod'] = $data->getPaymentMethod();
        }
        if ($data->isInitialized('shouldGenerateInvoice') && null !== $data->getShouldGenerateInvoice()) {
            $dataArray['shouldGenerateInvoice'] = $data->getShouldGenerateInvoice();
        }
        if ($data->isInitialized('specificBillingAccount') && null !== $data->getSpecificBillingAccount()) {
            $dataArray['specificBillingAccount'] = $this->normalizer->normalize($data->getSpecificBillingAccount(), 'json', $context);
        }
        if ($data->isInitialized('specificVeterinaryGroup') && null !== $data->getSpecificVeterinaryGroup()) {
            $dataArray['specificVeterinaryGroup'] = $this->normalizer->normalize($data->getSpecificVeterinaryGroup(), 'json', $context);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }

        return $dataArray;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return [\NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentServiceDeliveryRequest::class => false];
    }
}
