<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class SchemasVeterinaryEstablishmentCreditNoteRequestNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []): bool
    {
        return \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentCreditNoteRequest::class === $type;
    }

    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []): bool
    {
        return \is_object($data) && \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentCreditNoteRequest::class === $data::class;
    }

    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []): mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentCreditNoteRequest();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('accountingStatus', $data) && null !== $data['accountingStatus']) {
            $object->setAccountingStatus($data['accountingStatus']);
            unset($data['accountingStatus']);
        } elseif (\array_key_exists('accountingStatus', $data) && null === $data['accountingStatus']) {
            $object->setAccountingStatus(null);
        }
        if (\array_key_exists('documentCode', $data)) {
            $object->setDocumentCode($data['documentCode']);
            unset($data['documentCode']);
        }
        if (\array_key_exists('documentDate', $data)) {
            $object->setDocumentDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['documentDate']));
            unset($data['documentDate']);
        }
        if (\array_key_exists('documentType', $data)) {
            $object->setDocumentType($data['documentType']);
            unset($data['documentType']);
        }
        if (\array_key_exists('moderation', $data)) {
            $object->setModeration($this->denormalizer->denormalize($data['moderation'], \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentCreditNoteRequestModeration::class, 'json', $context));
            unset($data['moderation']);
        }
        if (\array_key_exists('unitPriceWithVat', $data)) {
            $object->setUnitPriceWithVat($data['unitPriceWithVat']);
            unset($data['unitPriceWithVat']);
        }
        if (\array_key_exists('veterinaryEstablishment', $data)) {
            $object->setVeterinaryEstablishment($this->denormalizer->denormalize($data['veterinaryEstablishment'], \NoahVet\Reef\Jane\Model\IdRequest::class, 'json', $context));
            unset($data['veterinaryEstablishment']);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    public function normalize(mixed $data, ?string $format = null, array $context = []): array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('accountingStatus') && null !== $data->getAccountingStatus()) {
            $dataArray['accountingStatus'] = $data->getAccountingStatus();
        }
        $dataArray['documentCode'] = $data->getDocumentCode();
        $dataArray['documentDate'] = $data->getDocumentDate()?->format('Y-m-d\\TH:i:sP');
        $dataArray['documentType'] = $data->getDocumentType();
        $dataArray['moderation'] = $this->normalizer->normalize($data->getModeration(), 'json', $context);
        $dataArray['unitPriceWithVat'] = $data->getUnitPriceWithVat();
        $dataArray['veterinaryEstablishment'] = $this->normalizer->normalize($data->getVeterinaryEstablishment(), 'json', $context);
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }

        return $dataArray;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return [\NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentCreditNoteRequest::class => false];
    }
}
