<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class SchemasLegalStructureRequestNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []): bool
    {
        return \NoahVet\Reef\Jane\Model\SchemasLegalStructureRequest::class === $type;
    }

    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []): bool
    {
        return \is_object($data) && \NoahVet\Reef\Jane\Model\SchemasLegalStructureRequest::class === $data::class;
    }

    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []): mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\SchemasLegalStructureRequest();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('apeCode', $data) && null !== $data['apeCode']) {
            $object->setApeCode($data['apeCode']);
            unset($data['apeCode']);
        } elseif (\array_key_exists('apeCode', $data) && null === $data['apeCode']) {
            $object->setApeCode(null);
        }
        if (\array_key_exists('legalCode', $data) && null !== $data['legalCode']) {
            $object->setLegalCode($data['legalCode']);
            unset($data['legalCode']);
        } elseif (\array_key_exists('legalCode', $data) && null === $data['legalCode']) {
            $object->setLegalCode(null);
        }
        if (\array_key_exists('legalForm', $data) && null !== $data['legalForm']) {
            $object->setLegalForm($data['legalForm']);
            unset($data['legalForm']);
        } elseif (\array_key_exists('legalForm', $data) && null === $data['legalForm']) {
            $object->setLegalForm(null);
        }
        if (\array_key_exists('headQuarterAddress', $data) && null !== $data['headQuarterAddress']) {
            $object->setHeadQuarterAddress($this->denormalizer->denormalize($data['headQuarterAddress'], \NoahVet\Reef\Jane\Model\SchemasPostalAddressRequest::class, 'json', $context));
            unset($data['headQuarterAddress']);
        } elseif (\array_key_exists('headQuarterAddress', $data) && null === $data['headQuarterAddress']) {
            $object->setHeadQuarterAddress(null);
        }
        if (\array_key_exists('socialReason', $data) && null !== $data['socialReason']) {
            $object->setSocialReason($data['socialReason']);
            unset($data['socialReason']);
        } elseif (\array_key_exists('socialReason', $data) && null === $data['socialReason']) {
            $object->setSocialReason(null);
        }
        if (\array_key_exists('tradeName', $data) && null !== $data['tradeName']) {
            $object->setTradeName($data['tradeName']);
            unset($data['tradeName']);
        } elseif (\array_key_exists('tradeName', $data) && null === $data['tradeName']) {
            $object->setTradeName(null);
        }
        if (\array_key_exists('vatIntraCommunityNumber', $data) && null !== $data['vatIntraCommunityNumber']) {
            $object->setVatIntraCommunityNumber($data['vatIntraCommunityNumber']);
            unset($data['vatIntraCommunityNumber']);
        } elseif (\array_key_exists('vatIntraCommunityNumber', $data) && null === $data['vatIntraCommunityNumber']) {
            $object->setVatIntraCommunityNumber(null);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    public function normalize(mixed $data, ?string $format = null, array $context = []): array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('apeCode') && null !== $data->getApeCode()) {
            $dataArray['apeCode'] = $data->getApeCode();
        }
        if ($data->isInitialized('legalCode') && null !== $data->getLegalCode()) {
            $dataArray['legalCode'] = $data->getLegalCode();
        }
        if ($data->isInitialized('legalForm') && null !== $data->getLegalForm()) {
            $dataArray['legalForm'] = $data->getLegalForm();
        }
        if ($data->isInitialized('headQuarterAddress') && null !== $data->getHeadQuarterAddress()) {
            $dataArray['headQuarterAddress'] = $this->normalizer->normalize($data->getHeadQuarterAddress(), 'json', $context);
        }
        if ($data->isInitialized('socialReason') && null !== $data->getSocialReason()) {
            $dataArray['socialReason'] = $data->getSocialReason();
        }
        if ($data->isInitialized('tradeName') && null !== $data->getTradeName()) {
            $dataArray['tradeName'] = $data->getTradeName();
        }
        if ($data->isInitialized('vatIntraCommunityNumber') && null !== $data->getVatIntraCommunityNumber()) {
            $dataArray['vatIntraCommunityNumber'] = $data->getVatIntraCommunityNumber();
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }

        return $dataArray;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return [\NoahVet\Reef\Jane\Model\SchemasLegalStructureRequest::class => false];
    }
}
