<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class PrincipalPrincipalGetNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []): bool
    {
        return \NoahVet\Reef\Jane\Model\PrincipalPrincipalGet::class === $type;
    }

    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []): bool
    {
        return \is_object($data) && \NoahVet\Reef\Jane\Model\PrincipalPrincipalGet::class === $data::class;
    }

    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []): mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\PrincipalPrincipalGet();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('type', $data)) {
            $object->setType($data['type']);
            unset($data['type']);
        }
        if (\array_key_exists('email', $data) && null !== $data['email']) {
            $object->setEmail($data['email']);
            unset($data['email']);
        } elseif (\array_key_exists('email', $data) && null === $data['email']) {
            $object->setEmail(null);
        }
        if (\array_key_exists('lastname', $data) && null !== $data['lastname']) {
            $object->setLastname($data['lastname']);
            unset($data['lastname']);
        } elseif (\array_key_exists('lastname', $data) && null === $data['lastname']) {
            $object->setLastname(null);
        }
        if (\array_key_exists('firstname', $data) && null !== $data['firstname']) {
            $object->setFirstname($data['firstname']);
            unset($data['firstname']);
        } elseif (\array_key_exists('firstname', $data) && null === $data['firstname']) {
            $object->setFirstname(null);
        }
        if (\array_key_exists('status', $data)) {
            $object->setStatus($data['status']);
            unset($data['status']);
        }
        if (\array_key_exists('lastLogin', $data) && null !== $data['lastLogin']) {
            $object->setLastLogin(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['lastLogin']));
            unset($data['lastLogin']);
        } elseif (\array_key_exists('lastLogin', $data) && null === $data['lastLogin']) {
            $object->setLastLogin(null);
        }
        if (\array_key_exists('locale', $data) && null !== $data['locale']) {
            $object->setLocale($data['locale']);
            unset($data['locale']);
        } elseif (\array_key_exists('locale', $data) && null === $data['locale']) {
            $object->setLocale(null);
        }
        if (\array_key_exists('timezone', $data) && null !== $data['timezone']) {
            $object->setTimezone($data['timezone']);
            unset($data['timezone']);
        } elseif (\array_key_exists('timezone', $data) && null === $data['timezone']) {
            $object->setTimezone(null);
        }
        if (\array_key_exists('birthDate', $data) && null !== $data['birthDate']) {
            $object->setBirthDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['birthDate']));
            unset($data['birthDate']);
        } elseif (\array_key_exists('birthDate', $data) && null === $data['birthDate']) {
            $object->setBirthDate(null);
        }
        if (\array_key_exists('birthPostCode', $data) && null !== $data['birthPostCode']) {
            $object->setBirthPostCode($data['birthPostCode']);
            unset($data['birthPostCode']);
        } elseif (\array_key_exists('birthPostCode', $data) && null === $data['birthPostCode']) {
            $object->setBirthPostCode(null);
        }
        if (\array_key_exists('birthCity', $data) && null !== $data['birthCity']) {
            $object->setBirthCity($data['birthCity']);
            unset($data['birthCity']);
        } elseif (\array_key_exists('birthCity', $data) && null === $data['birthCity']) {
            $object->setBirthCity(null);
        }
        if (\array_key_exists('birthCountry', $data) && null !== $data['birthCountry']) {
            $object->setBirthCountry($data['birthCountry']);
            unset($data['birthCountry']);
        } elseif (\array_key_exists('birthCountry', $data) && null === $data['birthCountry']) {
            $object->setBirthCountry(null);
        }
        if (\array_key_exists('mainAddress', $data)) {
            $object->setMainAddress($this->denormalizer->denormalize($data['mainAddress'], \NoahVet\Reef\Jane\Model\PostalAddress::class, 'json', $context));
            unset($data['mainAddress']);
        }
        if (\array_key_exists('privacyPolicyAccepted', $data) && null !== $data['privacyPolicyAccepted']) {
            $object->setPrivacyPolicyAccepted(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['privacyPolicyAccepted']));
            unset($data['privacyPolicyAccepted']);
        } elseif (\array_key_exists('privacyPolicyAccepted', $data) && null === $data['privacyPolicyAccepted']) {
            $object->setPrivacyPolicyAccepted(null);
        }
        if (\array_key_exists('phoneNumbers', $data)) {
            $values = [];
            foreach ($data['phoneNumbers'] as $value) {
                $values[] = $this->denormalizer->denormalize($value, \NoahVet\Reef\Jane\Model\PrincipalPhoneNumber::class, 'json', $context);
            }
            $object->setPhoneNumbers($values);
            unset($data['phoneNumbers']);
        }
        if (\array_key_exists('mainPhoneNumber', $data) && null !== $data['mainPhoneNumber']) {
            $object->setMainPhoneNumber($data['mainPhoneNumber']);
            unset($data['mainPhoneNumber']);
        } elseif (\array_key_exists('mainPhoneNumber', $data) && null === $data['mainPhoneNumber']) {
            $object->setMainPhoneNumber(null);
        }
        if (\array_key_exists('created', $data)) {
            $object->setCreated(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['created']));
            unset($data['created']);
        }
        if (\array_key_exists('updated', $data)) {
            $object->setUpdated(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updated']));
            unset($data['updated']);
        }
        foreach ($data as $key => $value_1) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_1;
            }
        }

        return $object;
    }

    public function normalize(mixed $data, ?string $format = null, array $context = []): array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('id') && null !== $data->getId()) {
            $dataArray['id'] = $data->getId();
        }
        if ($data->isInitialized('type') && null !== $data->getType()) {
            $dataArray['type'] = $data->getType();
        }
        if ($data->isInitialized('email') && null !== $data->getEmail()) {
            $dataArray['email'] = $data->getEmail();
        }
        if ($data->isInitialized('lastname') && null !== $data->getLastname()) {
            $dataArray['lastname'] = $data->getLastname();
        }
        if ($data->isInitialized('firstname') && null !== $data->getFirstname()) {
            $dataArray['firstname'] = $data->getFirstname();
        }
        if ($data->isInitialized('status') && null !== $data->getStatus()) {
            $dataArray['status'] = $data->getStatus();
        }
        if ($data->isInitialized('lastLogin') && null !== $data->getLastLogin()) {
            $dataArray['lastLogin'] = $data->getLastLogin()->format('Y-m-d\\TH:i:sP');
        }
        if ($data->isInitialized('locale') && null !== $data->getLocale()) {
            $dataArray['locale'] = $data->getLocale();
        }
        if ($data->isInitialized('timezone') && null !== $data->getTimezone()) {
            $dataArray['timezone'] = $data->getTimezone();
        }
        if ($data->isInitialized('birthDate') && null !== $data->getBirthDate()) {
            $dataArray['birthDate'] = $data->getBirthDate()->format('Y-m-d\\TH:i:sP');
        }
        if ($data->isInitialized('birthPostCode') && null !== $data->getBirthPostCode()) {
            $dataArray['birthPostCode'] = $data->getBirthPostCode();
        }
        if ($data->isInitialized('birthCity') && null !== $data->getBirthCity()) {
            $dataArray['birthCity'] = $data->getBirthCity();
        }
        if ($data->isInitialized('birthCountry') && null !== $data->getBirthCountry()) {
            $dataArray['birthCountry'] = $data->getBirthCountry();
        }
        if ($data->isInitialized('mainAddress') && null !== $data->getMainAddress()) {
            $dataArray['mainAddress'] = $this->normalizer->normalize($data->getMainAddress(), 'json', $context);
        }
        if ($data->isInitialized('privacyPolicyAccepted') && null !== $data->getPrivacyPolicyAccepted()) {
            $dataArray['privacyPolicyAccepted'] = $data->getPrivacyPolicyAccepted()->format('Y-m-d\\TH:i:sP');
        }
        if ($data->isInitialized('phoneNumbers') && null !== $data->getPhoneNumbers()) {
            $values = [];
            foreach ($data->getPhoneNumbers() as $value) {
                $values[] = $this->normalizer->normalize($value, 'json', $context);
            }
            $dataArray['phoneNumbers'] = $values;
        }
        if ($data->isInitialized('mainPhoneNumber') && null !== $data->getMainPhoneNumber()) {
            $dataArray['mainPhoneNumber'] = $data->getMainPhoneNumber();
        }
        if ($data->isInitialized('created') && null !== $data->getCreated()) {
            $dataArray['created'] = $data->getCreated()?->format('Y-m-d\\TH:i:sP');
        }
        if ($data->isInitialized('updated') && null !== $data->getUpdated()) {
            $dataArray['updated'] = $data->getUpdated()?->format('Y-m-d\\TH:i:sP');
        }
        foreach ($data as $key => $value_1) {
            if (\preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value_1;
            }
        }

        return $dataArray;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return [\NoahVet\Reef\Jane\Model\PrincipalPrincipalGet::class => false];
    }
}
