<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class PrincipalPhoneNumberNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []): bool
    {
        return \NoahVet\Reef\Jane\Model\PrincipalPhoneNumber::class === $type;
    }

    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []): bool
    {
        return \is_object($data) && \NoahVet\Reef\Jane\Model\PrincipalPhoneNumber::class === $data::class;
    }

    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []): mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\PrincipalPhoneNumber();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('phoneNumber', $data)) {
            $object->setPhoneNumber($data['phoneNumber']);
            unset($data['phoneNumber']);
        }
        if (\array_key_exists('validated', $data) && null !== $data['validated']) {
            $object->setValidated(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['validated']));
            unset($data['validated']);
        } elseif (\array_key_exists('validated', $data) && null === $data['validated']) {
            $object->setValidated(null);
        }
        if (\array_key_exists('validationMethod', $data) && null !== $data['validationMethod']) {
            $value = $data['validationMethod'];
            if (\is_array($data['validationMethod'])) {
                $value = $this->denormalizer->denormalize($data['validationMethod'], \NoahVet\Reef\Jane\Model\PhoneValidationMethodEnum::class, 'json', $context);
            }
            $object->setValidationMethod($value);
            unset($data['validationMethod']);
        } elseif (\array_key_exists('validationMethod', $data) && null === $data['validationMethod']) {
            $object->setValidationMethod(null);
        }
        foreach ($data as $key => $value_1) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_1;
            }
        }

        return $object;
    }

    public function normalize(mixed $data, ?string $format = null, array $context = []): array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('phoneNumber') && null !== $data->getPhoneNumber()) {
            $dataArray['phoneNumber'] = $data->getPhoneNumber();
        }
        if ($data->isInitialized('validated') && null !== $data->getValidated()) {
            $dataArray['validated'] = $data->getValidated()->format('Y-m-d\\TH:i:sP');
        }
        if ($data->isInitialized('validationMethod') && null !== $data->getValidationMethod()) {
            $value = $data->getValidationMethod();
            if (\is_object($data->getValidationMethod())) {
                $value = $this->normalizer->normalize($data->getValidationMethod(), 'json', $context);
            }
            $dataArray['validationMethod'] = $value;
        }
        foreach ($data as $key => $value_1) {
            if (\preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value_1;
            }
        }

        return $dataArray;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return [\NoahVet\Reef\Jane\Model\PrincipalPhoneNumber::class => false];
    }
}
