<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class PostalAddressResponseNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []): bool
    {
        return \NoahVet\Reef\Jane\Model\PostalAddressResponse::class === $type;
    }

    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []): bool
    {
        return \is_object($data) && \NoahVet\Reef\Jane\Model\PostalAddressResponse::class === $data::class;
    }

    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []): mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\PostalAddressResponse();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('createdDate', $data)) {
            $object->setCreatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['createdDate']));
            unset($data['createdDate']);
        }
        if (\array_key_exists('updatedDate', $data)) {
            $object->setUpdatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updatedDate']));
            unset($data['updatedDate']);
        }
        if (\array_key_exists('addressSupplement', $data) && null !== $data['addressSupplement']) {
            $object->setAddressSupplement($data['addressSupplement']);
            unset($data['addressSupplement']);
        } elseif (\array_key_exists('addressSupplement', $data) && null === $data['addressSupplement']) {
            $object->setAddressSupplement(null);
        }
        if (\array_key_exists('city', $data)) {
            $object->setCity($data['city']);
            unset($data['city']);
        }
        if (\array_key_exists('coordinates', $data) && null !== $data['coordinates']) {
            $object->setCoordinates($this->denormalizer->denormalize($data['coordinates'], \NoahVet\Reef\Jane\Model\CoordinateResponse::class, 'json', $context));
            unset($data['coordinates']);
        } elseif (\array_key_exists('coordinates', $data) && null === $data['coordinates']) {
            $object->setCoordinates(null);
        }
        if (\array_key_exists('country', $data)) {
            $object->setCountry($data['country']);
            unset($data['country']);
        }
        if (\array_key_exists('department', $data) && null !== $data['department']) {
            $object->setDepartment($data['department']);
            unset($data['department']);
        } elseif (\array_key_exists('department', $data) && null === $data['department']) {
            $object->setDepartment(null);
        }
        if (\array_key_exists('entitled', $data) && null !== $data['entitled']) {
            $object->setEntitled($data['entitled']);
            unset($data['entitled']);
        } elseif (\array_key_exists('entitled', $data) && null === $data['entitled']) {
            $object->setEntitled(null);
        }
        if (\array_key_exists('postalCode', $data)) {
            $object->setPostalCode($data['postalCode']);
            unset($data['postalCode']);
        }
        if (\array_key_exists('postBoxNumber', $data) && null !== $data['postBoxNumber']) {
            $object->setPostBoxNumber($data['postBoxNumber']);
            unset($data['postBoxNumber']);
        } elseif (\array_key_exists('postBoxNumber', $data) && null === $data['postBoxNumber']) {
            $object->setPostBoxNumber(null);
        }
        if (\array_key_exists('recipientIdentity', $data) && null !== $data['recipientIdentity']) {
            $object->setRecipientIdentity($data['recipientIdentity']);
            unset($data['recipientIdentity']);
        } elseif (\array_key_exists('recipientIdentity', $data) && null === $data['recipientIdentity']) {
            $object->setRecipientIdentity(null);
        }
        if (\array_key_exists('region', $data) && null !== $data['region']) {
            $object->setRegion($data['region']);
            unset($data['region']);
        } elseif (\array_key_exists('region', $data) && null === $data['region']) {
            $object->setRegion(null);
        }
        if (\array_key_exists('streetName', $data)) {
            $object->setStreetName($data['streetName']);
            unset($data['streetName']);
        }
        if (\array_key_exists('streetNumber', $data) && null !== $data['streetNumber']) {
            $object->setStreetNumber($data['streetNumber']);
            unset($data['streetNumber']);
        } elseif (\array_key_exists('streetNumber', $data) && null === $data['streetNumber']) {
            $object->setStreetNumber(null);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    public function normalize(mixed $data, ?string $format = null, array $context = []): array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('id') && null !== $data->getId()) {
            $dataArray['id'] = $data->getId();
        }
        if ($data->isInitialized('createdDate') && null !== $data->getCreatedDate()) {
            $dataArray['createdDate'] = $data->getCreatedDate()?->format('Y-m-d\\TH:i:sP');
        }
        if ($data->isInitialized('updatedDate') && null !== $data->getUpdatedDate()) {
            $dataArray['updatedDate'] = $data->getUpdatedDate()?->format('Y-m-d\\TH:i:sP');
        }
        $dataArray['addressSupplement'] = $data->getAddressSupplement();
        $dataArray['city'] = $data->getCity();
        $dataArray['coordinates'] = $this->normalizer->normalize($data->getCoordinates(), 'json', $context);
        $dataArray['country'] = $data->getCountry();
        $dataArray['department'] = $data->getDepartment();
        $dataArray['entitled'] = $data->getEntitled();
        $dataArray['postalCode'] = $data->getPostalCode();
        $dataArray['postBoxNumber'] = $data->getPostBoxNumber();
        $dataArray['recipientIdentity'] = $data->getRecipientIdentity();
        $dataArray['region'] = $data->getRegion();
        $dataArray['streetName'] = $data->getStreetName();
        $dataArray['streetNumber'] = $data->getStreetNumber();
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }

        return $dataArray;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return [\NoahVet\Reef\Jane\Model\PostalAddressResponse::class => false];
    }
}
