<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class JaneObjectNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    protected $normalizers = [
        \NoahVet\Reef\Jane\Model\NullableIdResponse::class => NullableIdResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\IdResponse::class => IdResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\BillingAccountResponseItem::class => BillingAccountResponseItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\NullableIdRequest::class => NullableIdRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\IdRequest::class => IdRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\BillingAccountRequest::class => BillingAccountRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasBillingAccountResponse::class => SchemasBillingAccountResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\ComponentsSchemasBillingAccountResponse::class => ComponentsSchemasBillingAccountResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasBillingAccountRequest::class => SchemasBillingAccountRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\BillingAccountResponseComponentsSchemasBillingAccountResponse::class => BillingAccountResponseComponentsSchemasBillingAccountResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\YousignSignatureRequestResponse::class => YousignSignatureRequestResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\CreditNoteBankTransferRequest::class => CreditNoteBankTransferRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\CreditNoteBankTransferResponse::class => CreditNoteBankTransferResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\InvoiceDirectDebitRequest::class => InvoiceDirectDebitRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\InvoiceDirectDebitResponse::class => InvoiceDirectDebitResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\MandateResponse::class => MandateResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\ContractResponse::class => ContractResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\ContractRequest::class => ContractRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\ContractDocumentResponse::class => ContractDocumentResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\InvitationResponse::class => InvitationResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserInvitationRequest::class => VeterinaryEstablishmentUserInvitationRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserInvitationResponse::class => VeterinaryEstablishmentUserInvitationResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserInvitationConfirmationRequest::class => VeterinaryEstablishmentUserInvitationConfirmationRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserInvitationConfirmationResponse::class => VeterinaryEstablishmentUserInvitationConfirmationResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryGroupUserInvitationRequest::class => VeterinaryGroupUserInvitationRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryGroupUserInvitationResponse::class => VeterinaryGroupUserInvitationResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryGroupUserInvitationConfirmationRequest::class => VeterinaryGroupUserInvitationConfirmationRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryGroupUserInvitationConfirmationResponse::class => VeterinaryGroupUserInvitationConfirmationResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\InvoiceAddressResponse::class => InvoiceAddressResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\InvoiceInformationResponse::class => InvoiceInformationResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\CreditNoteResponse::class => CreditNoteResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\CreditNoteResponseAccountingMovement::class => CreditNoteResponseAccountingMovementNormalizer::class,

        \NoahVet\Reef\Jane\Model\CreditNoteResponseBankAccount::class => CreditNoteResponseBankAccountNormalizer::class,

        \NoahVet\Reef\Jane\Model\CreditNoteResponseCreditNoteLinesItem::class => CreditNoteResponseCreditNoteLinesItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\InvoiceAddressRequest::class => InvoiceAddressRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\CreditNoteRequest::class => CreditNoteRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\CreditNoteRequestDeliveryInformation::class => CreditNoteRequestDeliveryInformationNormalizer::class,

        \NoahVet\Reef\Jane\Model\CreditNoteRequestReceiverInformation::class => CreditNoteRequestReceiverInformationNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasCreditNoteRequest::class => SchemasCreditNoteRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\InvoiceResponse::class => InvoiceResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\InvoiceResponseAccountingMovement::class => InvoiceResponseAccountingMovementNormalizer::class,

        \NoahVet\Reef\Jane\Model\InvoiceResponseBankAccount::class => InvoiceResponseBankAccountNormalizer::class,

        \NoahVet\Reef\Jane\Model\InvoiceResponseInvoiceLinesItem::class => InvoiceResponseInvoiceLinesItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\InvoiceRequest::class => InvoiceRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\ServiceDeliveryInvoiceRequest::class => ServiceDeliveryInvoiceRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\ServiceDeliveryInvoiceResponse::class => ServiceDeliveryInvoiceResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentCreditNoteRequest::class => VeterinaryEstablishmentCreditNoteRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentCreditNoteRequestBankAccount::class => VeterinaryEstablishmentCreditNoteRequestBankAccountNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentCreditNoteRequestCreditNoteLinesItem::class => VeterinaryEstablishmentCreditNoteRequestCreditNoteLinesItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentCreditNoteRequestDeliveryInformation::class => VeterinaryEstablishmentCreditNoteRequestDeliveryInformationNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentInvoiceRequest::class => VeterinaryEstablishmentInvoiceRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentInvoiceRequestDeliveryInformation::class => VeterinaryEstablishmentInvoiceRequestDeliveryInformationNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentInvoiceRequestInvoiceLinesItem::class => VeterinaryEstablishmentInvoiceRequestInvoiceLinesItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\CoordinateResponse::class => CoordinateResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\PostalAddressResponse::class => PostalAddressResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\LegalStructureResponseItem::class => LegalStructureResponseItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\CoordinateRequest::class => CoordinateRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\PostalAddressRequest::class => PostalAddressRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\LegalStructureRequest::class => LegalStructureRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasLegalStructureResponse::class => SchemasLegalStructureResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\ComponentsSchemasLegalStructureResponse::class => ComponentsSchemasLegalStructureResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasPostalAddressRequest::class => SchemasPostalAddressRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasLegalStructureRequest::class => SchemasLegalStructureRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\LegalStructureResponseComponentsSchemasLegalStructureResponse::class => LegalStructureResponseComponentsSchemasLegalStructureResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\SearchRequest::class => SearchRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\LegalStructureSearchResponseItem::class => LegalStructureSearchResponseItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\RequiredMandateResponseItem::class => RequiredMandateResponseItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\RequiredMandateResponseItemFilledMandate::class => RequiredMandateResponseItemFilledMandateNormalizer::class,

        \NoahVet\Reef\Jane\Model\RequiredMandateRequest::class => RequiredMandateRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasRequiredMandateResponse::class => SchemasRequiredMandateResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasRequiredMandateResponseFilledMandate::class => SchemasRequiredMandateResponseFilledMandateNormalizer::class,

        \NoahVet\Reef\Jane\Model\ComponentsSchemasRequiredMandateResponse::class => ComponentsSchemasRequiredMandateResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\ComponentsSchemasRequiredMandateResponseFilledMandate::class => ComponentsSchemasRequiredMandateResponseFilledMandateNormalizer::class,

        \NoahVet\Reef\Jane\Model\ManufacturerResponseItem::class => ManufacturerResponseItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\ManufacturerResponseItemBanner::class => ManufacturerResponseItemBannerNormalizer::class,

        \NoahVet\Reef\Jane\Model\ManufacturerResponseItemLegalStructure::class => ManufacturerResponseItemLegalStructureNormalizer::class,

        \NoahVet\Reef\Jane\Model\ManufacturerResponseItemLogo::class => ManufacturerResponseItemLogoNormalizer::class,

        \NoahVet\Reef\Jane\Model\ManufacturerResponseItemPicturesItem::class => ManufacturerResponseItemPicturesItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\DocumentResponse::class => DocumentResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\DocumentRequest::class => DocumentRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\ImageResponseItem::class => ImageResponseItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\ImageRequest::class => ImageRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasImageResponse::class => SchemasImageResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServiceDeliveryResponse::class => VeterinaryEstablishmentServiceDeliveryResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServiceDeliveryRequest::class => VeterinaryEstablishmentServiceDeliveryRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentServiceDeliveryRequest::class => SchemasVeterinaryEstablishmentServiceDeliveryRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\ServiceDeliveryOptionResponse::class => ServiceDeliveryOptionResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\ServiceDeliveryOptionRequest::class => ServiceDeliveryOptionRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasServiceDeliveryOptionRequest::class => SchemasServiceDeliveryOptionRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\ManufacturerUserResponseItem::class => ManufacturerUserResponseItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\ManufacturerUserResponseItemManufacturer::class => ManufacturerUserResponseItemManufacturerNormalizer::class,

        \NoahVet\Reef\Jane\Model\ManufacturerUserResponseItemUser::class => ManufacturerUserResponseItemUserNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserResponse::class => VeterinaryEstablishmentUserResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserResponseUser::class => VeterinaryEstablishmentUserResponseUserNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserResponseVeterinaryEstablishment::class => VeterinaryEstablishmentUserResponseVeterinaryEstablishmentNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserRequest::class => VeterinaryEstablishmentUserRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentUserRequest::class => SchemasVeterinaryEstablishmentUserRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\ComponentsSchemasVeterinaryEstablishmentUserResponse::class => ComponentsSchemasVeterinaryEstablishmentUserResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryGroupUserResponse::class => VeterinaryGroupUserResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryGroupUserResponseUser::class => VeterinaryGroupUserResponseUserNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryGroupUserResponseVeterinaryGroup::class => VeterinaryGroupUserResponseVeterinaryGroupNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryGroupUserRequest::class => VeterinaryGroupUserRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasVeterinaryGroupUserRequest::class => SchemasVeterinaryGroupUserRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\ComponentsSchemasVeterinaryGroupUserResponse::class => ComponentsSchemasVeterinaryGroupUserResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\OpeningHourResponse::class => OpeningHourResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\OpeningPeriodResponse::class => OpeningPeriodResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\ScheduleResponse::class => ScheduleResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentResponse::class => VeterinaryEstablishmentResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\OpeningHourRequest::class => OpeningHourRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\OpeningPeriodRequest::class => OpeningPeriodRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentRequest::class => VeterinaryEstablishmentRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentRequestSchedule::class => VeterinaryEstablishmentRequestScheduleNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentRequest::class => SchemasVeterinaryEstablishmentRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentRequestSchedule::class => SchemasVeterinaryEstablishmentRequestScheduleNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentAddressResponse::class => VeterinaryEstablishmentAddressResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentAddressResponsePhone::class => VeterinaryEstablishmentAddressResponsePhoneNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentAddressRequest::class => VeterinaryEstablishmentAddressRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentAddressRequestPhone::class => VeterinaryEstablishmentAddressRequestPhoneNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentAddressRequest::class => SchemasVeterinaryEstablishmentAddressRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentAddressRequestPhone::class => SchemasVeterinaryEstablishmentAddressRequestPhoneNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentMemberResponse::class => VeterinaryEstablishmentMemberResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentMemberRequest::class => VeterinaryEstablishmentMemberRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentMemberRequest::class => SchemasVeterinaryEstablishmentMemberRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentMemberSearchRequest::class => VeterinaryEstablishmentMemberSearchRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentActivityResponseItem::class => VeterinaryEstablishmentActivityResponseItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentActivityRequest::class => VeterinaryEstablishmentActivityRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentActivityResponse::class => SchemasVeterinaryEstablishmentActivityResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentActivityRequest::class => SchemasVeterinaryEstablishmentActivityRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\ComponentsSchemasVeterinaryEstablishmentActivityResponse::class => ComponentsSchemasVeterinaryEstablishmentActivityResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentMandateResponse::class => VeterinaryEstablishmentMandateResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentMandateRequest::class => VeterinaryEstablishmentMandateRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentMandateRequest::class => SchemasVeterinaryEstablishmentMandateRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServicePeriodResponseItem::class => VeterinaryEstablishmentServicePeriodResponseItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServicePeriodResponseItemAttributesItem::class => VeterinaryEstablishmentServicePeriodResponseItemAttributesItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServiceSubscriptionResponseItem::class => VeterinaryEstablishmentServiceSubscriptionResponseItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServiceSubscriptionResponseItemAttributesItem::class => VeterinaryEstablishmentServiceSubscriptionResponseItemAttributesItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServiceSubscriptionRequest::class => VeterinaryEstablishmentServiceSubscriptionRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServiceSubscriptionRequestAttributesItem::class => VeterinaryEstablishmentServiceSubscriptionRequestAttributesItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentServiceSubscriptionResponse::class => SchemasVeterinaryEstablishmentServiceSubscriptionResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentServiceSubscriptionResponseAttributesItem::class => SchemasVeterinaryEstablishmentServiceSubscriptionResponseAttributesItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServiceSubscriptionReductionRequest::class => VeterinaryEstablishmentServiceSubscriptionReductionRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServiceSubscriptionReductionResponse::class => VeterinaryEstablishmentServiceSubscriptionReductionResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServiceSubscriptionReductionResponseAttributesItem::class => VeterinaryEstablishmentServiceSubscriptionReductionResponseAttributesItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentServiceSubscriptionRequest::class => SchemasVeterinaryEstablishmentServiceSubscriptionRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentServiceSubscriptionRequestAttributesItem::class => SchemasVeterinaryEstablishmentServiceSubscriptionRequestAttributesItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\ComponentsSchemasVeterinaryEstablishmentServiceSubscriptionResponse::class => ComponentsSchemasVeterinaryEstablishmentServiceSubscriptionResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\ComponentsSchemasVeterinaryEstablishmentServiceSubscriptionResponseAttributesItem::class => ComponentsSchemasVeterinaryEstablishmentServiceSubscriptionResponseAttributesItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServiceDiscountResponseItem::class => VeterinaryEstablishmentServiceDiscountResponseItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServiceDiscountRequest::class => VeterinaryEstablishmentServiceDiscountRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentServiceDiscountResponse::class => SchemasVeterinaryEstablishmentServiceDiscountResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentServiceDiscountRequest::class => SchemasVeterinaryEstablishmentServiceDiscountRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\ComponentsSchemasVeterinaryEstablishmentServiceDiscountResponse::class => ComponentsSchemasVeterinaryEstablishmentServiceDiscountResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServiceDeliveryDiscountResponseItem::class => VeterinaryEstablishmentServiceDeliveryDiscountResponseItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServiceDeliveryDiscountRequest::class => VeterinaryEstablishmentServiceDeliveryDiscountRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentServiceDeliveryDiscountResponse::class => SchemasVeterinaryEstablishmentServiceDeliveryDiscountResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentServiceDeliveryDiscountRequest::class => SchemasVeterinaryEstablishmentServiceDeliveryDiscountRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\ComponentsSchemasVeterinaryEstablishmentServiceDeliveryDiscountResponse::class => ComponentsSchemasVeterinaryEstablishmentServiceDeliveryDiscountResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentLabellingResponse::class => VeterinaryEstablishmentLabellingResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentLabellingRequest::class => VeterinaryEstablishmentLabellingRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentTagResponse::class => VeterinaryEstablishmentTagResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentTagRequest::class => VeterinaryEstablishmentTagRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryGroupResponse::class => VeterinaryGroupResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryGroupRequest::class => VeterinaryGroupRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasVeterinaryGroupRequest::class => SchemasVeterinaryGroupRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryGroupSearchRequest::class => VeterinaryGroupSearchRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryGroupMandateResponse::class => VeterinaryGroupMandateResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryGroupMandateRequest::class => VeterinaryGroupMandateRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasVeterinaryGroupMandateRequest::class => SchemasVeterinaryGroupMandateRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryServiceResponseItem::class => VeterinaryServiceResponseItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryServiceResponseItemBanner::class => VeterinaryServiceResponseItemBannerNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryServiceResponseItemCreditor::class => VeterinaryServiceResponseItemCreditorNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryServiceOptionResponse::class => VeterinaryServiceOptionResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryServiceOptionRequest::class => VeterinaryServiceOptionRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryServiceOptionConfigResponseItem::class => VeterinaryServiceOptionConfigResponseItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryServiceOptionConfigResponseItemAccountingCodesItem::class => VeterinaryServiceOptionConfigResponseItemAccountingCodesItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryServiceOptionConfigResponseItemVeterinaryServiceOption::class => VeterinaryServiceOptionConfigResponseItemVeterinaryServiceOptionNormalizer::class,

        \NoahVet\Reef\Jane\Model\YouSignContractConfirmationRequest::class => YouSignContractConfirmationRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\YouSignContractConfirmationRequestData::class => YouSignContractConfirmationRequestDataNormalizer::class,

        \NoahVet\Reef\Jane\Model\YouSignContractConfirmationRequestDataSignatureRequest::class => YouSignContractConfirmationRequestDataSignatureRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentCreditNoteResponseItem::class => VeterinaryEstablishmentCreditNoteResponseItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentCreditNoteResponseItemModeration::class => VeterinaryEstablishmentCreditNoteResponseItemModerationNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentCreditNoteResponseItemVeterinaryEstablishment::class => VeterinaryEstablishmentCreditNoteResponseItemVeterinaryEstablishmentNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentCreditNoteRequest::class => SchemasVeterinaryEstablishmentCreditNoteRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentCreditNoteRequestModeration::class => SchemasVeterinaryEstablishmentCreditNoteRequestModerationNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentCreditNoteResponse::class => SchemasVeterinaryEstablishmentCreditNoteResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentCreditNoteResponseModeration::class => SchemasVeterinaryEstablishmentCreditNoteResponseModerationNormalizer::class,

        \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentCreditNoteResponseVeterinaryEstablishment::class => SchemasVeterinaryEstablishmentCreditNoteResponseVeterinaryEstablishmentNormalizer::class,

        \NoahVet\Reef\Jane\Model\ComponentsSchemasVeterinaryEstablishmentCreditNoteRequest::class => ComponentsSchemasVeterinaryEstablishmentCreditNoteRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\ComponentsSchemasVeterinaryEstablishmentCreditNoteResponse::class => ComponentsSchemasVeterinaryEstablishmentCreditNoteResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\ComponentsSchemasVeterinaryEstablishmentCreditNoteResponseModeration::class => ComponentsSchemasVeterinaryEstablishmentCreditNoteResponseModerationNormalizer::class,

        \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentCreditNoteBulkRequest::class => VeterinaryEstablishmentCreditNoteBulkRequestNormalizer::class,

        \NoahVet\Reef\Jane\Model\Client::class => ClientNormalizer::class,

        \NoahVet\Reef\Jane\Model\ClientGet::class => ClientGetNormalizer::class,

        \NoahVet\Reef\Jane\Model\CountryTypeEnum::class => CountryTypeEnumNormalizer::class,

        \NoahVet\Reef\Jane\Model\GrantedPermissionShort::class => GrantedPermissionShortNormalizer::class,

        \NoahVet\Reef\Jane\Model\InvitationEmailStatusEnum::class => InvitationEmailStatusEnumNormalizer::class,

        \NoahVet\Reef\Jane\Model\PhoneValidationMethodEnum::class => PhoneValidationMethodEnumNormalizer::class,

        \NoahVet\Reef\Jane\Model\PolicyResultPolicyResultGet::class => PolicyResultPolicyResultGetNormalizer::class,

        \NoahVet\Reef\Jane\Model\PolicyResultPolicyResultPost::class => PolicyResultPolicyResultPostNormalizer::class,

        \NoahVet\Reef\Jane\Model\PostalAddress::class => PostalAddressNormalizer::class,

        \NoahVet\Reef\Jane\Model\Principal::class => PrincipalNormalizer::class,

        \NoahVet\Reef\Jane\Model\PrincipalPrincipalGet::class => PrincipalPrincipalGetNormalizer::class,

        \NoahVet\Reef\Jane\Model\PrincipalPrincipalPatch::class => PrincipalPrincipalPatchNormalizer::class,

        \NoahVet\Reef\Jane\Model\PrincipalPrincipalPut::class => PrincipalPrincipalPutNormalizer::class,

        \NoahVet\Reef\Jane\Model\PrincipalGroup::class => PrincipalGroupNormalizer::class,

        \NoahVet\Reef\Jane\Model\PrincipalInvitation::class => PrincipalInvitationNormalizer::class,

        \NoahVet\Reef\Jane\Model\PrincipalPhoneNumber::class => PrincipalPhoneNumberNormalizer::class,

        \NoahVet\Reef\Jane\Model\PrincipalStatusEnum::class => PrincipalStatusEnumNormalizer::class,

        \NoahVet\Reef\Jane\Model\PrincipalTypeEnum::class => PrincipalTypeEnumNormalizer::class,

        \NoahVet\Reef\Jane\Model\Resource::class => ResourceNormalizer::class,

        \NoahVet\Reef\Jane\Model\ResourceGroupResourceGroupGet::class => ResourceGroupResourceGroupGetNormalizer::class,

        \NoahVet\Reef\Jane\Model\ResourceGroupResourceGroupPost::class => ResourceGroupResourceGroupPostNormalizer::class,

        \NoahVet\Reef\Jane\Model\ResourceGroupResourceGroupPut::class => ResourceGroupResourceGroupPutNormalizer::class,

        \NoahVet\Reef\Jane\Model\ResourceType::class => ResourceTypeNormalizer::class,

        \NoahVet\Reef\Jane\Model\ResourceTypeGetshort::class => ResourceTypeGetshortNormalizer::class,

        \NoahVet\Reef\Jane\Model\PermissionGrant::class => PermissionGrantNormalizer::class,

        \NoahVet\Reef\Jane\Model\PermissionGrantList::class => PermissionGrantListNormalizer::class,

        \NoahVet\Reef\Jane\Model\PrincipalShort::class => PrincipalShortNormalizer::class,

        \NoahVet\Reef\Jane\Model\PrincipalGet::class => PrincipalGetNormalizer::class,

        \NoahVet\Reef\Jane\Model\PrincipalGetPhoneNumbersItem::class => PrincipalGetPhoneNumbersItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\PrincipalPut::class => PrincipalPutNormalizer::class,

        \NoahVet\Reef\Jane\Model\PrincipalPutPhoneNumbersItem::class => PrincipalPutPhoneNumbersItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\ServicePermission::class => ServicePermissionNormalizer::class,

        \NoahVet\Reef\Jane\Model\ServiceResource::class => ServiceResourceNormalizer::class,

        \NoahVet\Reef\Jane\Model\ServiceExternalResource::class => ServiceExternalResourceNormalizer::class,

        \NoahVet\Reef\Jane\Model\ServiceDefinition::class => ServiceDefinitionNormalizer::class,

        \NoahVet\Reef\Jane\Model\ResourceGroupGet::class => ResourceGroupGetNormalizer::class,

        \NoahVet\Reef\Jane\Model\ResourceGroupPost::class => ResourceGroupPostNormalizer::class,

        \NoahVet\Reef\Jane\Model\ResourceGroupPut::class => ResourceGroupPutNormalizer::class,

        \NoahVet\Reef\Jane\Model\SupplierOrderResponse::class => SupplierOrderResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\WebOrderProductResponse::class => WebOrderProductResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\WebOrderDiscountResponse::class => WebOrderDiscountResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\WebOrderPaymentResponse::class => WebOrderPaymentResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\WebOrderPatchResponse::class => WebOrderPatchResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\WebOrderResponse::class => WebOrderResponseNormalizer::class,

        \NoahVet\Reef\Jane\Model\ProductPriceResponseItem::class => ProductPriceResponseItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\ProductPriceResponseItemAlcyonProduct::class => ProductPriceResponseItemAlcyonProductNormalizer::class,

        \NoahVet\Reef\Jane\Model\ProductPriceResponseItemCentravetProduct::class => ProductPriceResponseItemCentravetProductNormalizer::class,

        \NoahVet\Reef\Jane\Model\ProductPriceResponseItemCovetoProduct::class => ProductPriceResponseItemCovetoProductNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1ContactsGetResponse200Item::class => V1ContactsGetResponse200ItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1ContactsGetResponse200ItemCompanyDetail::class => V1ContactsGetResponse200ItemCompanyDetailNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1ContactsGetResponse200ItemCustomerProfile::class => V1ContactsGetResponse200ItemCustomerProfileNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1ContactsGetResponse200ItemGeolocation::class => V1ContactsGetResponse200ItemGeolocationNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1ContactsGetResponse206Item::class => V1ContactsGetResponse206ItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1ContactsGetResponse206ItemCompanyDetail::class => V1ContactsGetResponse206ItemCompanyDetailNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1ContactsGetResponse206ItemCustomerProfile::class => V1ContactsGetResponse206ItemCustomerProfileNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1ContactsGetResponse206ItemGeolocation::class => V1ContactsGetResponse206ItemGeolocationNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1ContactsPostBody::class => V1ContactsPostBodyNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1ContactsPostBodyCompanyDetail::class => V1ContactsPostBodyCompanyDetailNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1ContactsPostBodyCustomerProfile::class => V1ContactsPostBodyCustomerProfileNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1ContactsPostBodyGeolocation::class => V1ContactsPostBodyGeolocationNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1ContactsPostResponse201::class => V1ContactsPostResponse201Normalizer::class,

        \NoahVet\Reef\Jane\Model\V1ContactsPostResponse201CompanyDetail::class => V1ContactsPostResponse201CompanyDetailNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1ContactsPostResponse201CustomerProfile::class => V1ContactsPostResponse201CustomerProfileNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1ContactsPostResponse201Geolocation::class => V1ContactsPostResponse201GeolocationNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1ContactsIdPatchBody::class => V1ContactsIdPatchBodyNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1ContactsIdPatchBodyCompanyDetail::class => V1ContactsIdPatchBodyCompanyDetailNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1ContactsIdPatchBodyGeolocation::class => V1ContactsIdPatchBodyGeolocationNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1ContactsIdPatchResponse200::class => V1ContactsIdPatchResponse200Normalizer::class,

        \NoahVet\Reef\Jane\Model\V1ContactsIdPatchResponse200CompanyDetail::class => V1ContactsIdPatchResponse200CompanyDetailNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1ContactsIdPatchResponse200CustomerProfile::class => V1ContactsIdPatchResponse200CustomerProfileNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1ContactsIdPatchResponse200Geolocation::class => V1ContactsIdPatchResponse200GeolocationNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1CustomersGetResponse200Item::class => V1CustomersGetResponse200ItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1CustomersGetResponse206Item::class => V1CustomersGetResponse206ItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1CustomersIdPatchBody::class => V1CustomersIdPatchBodyNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1CustomersIdPatchResponse200::class => V1CustomersIdPatchResponse200Normalizer::class,

        \NoahVet\Reef\Jane\Model\V1CustomerProfilesGetResponse200Item::class => V1CustomerProfilesGetResponse200ItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1CustomerProfilesGetResponse200ItemBillingContact::class => V1CustomerProfilesGetResponse200ItemBillingContactNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1CustomerProfilesGetResponse200ItemCustomer::class => V1CustomerProfilesGetResponse200ItemCustomerNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1CustomerProfilesGetResponse200ItemDeliveryContact::class => V1CustomerProfilesGetResponse200ItemDeliveryContactNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1CustomerProfilesGetResponse200ItemMainContact::class => V1CustomerProfilesGetResponse200ItemMainContactNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1CustomerProfilesGetResponse206Item::class => V1CustomerProfilesGetResponse206ItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1CustomerProfilesGetResponse206ItemBillingContact::class => V1CustomerProfilesGetResponse206ItemBillingContactNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1CustomerProfilesGetResponse206ItemCustomer::class => V1CustomerProfilesGetResponse206ItemCustomerNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1CustomerProfilesGetResponse206ItemDeliveryContact::class => V1CustomerProfilesGetResponse206ItemDeliveryContactNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1CustomerProfilesGetResponse206ItemMainContact::class => V1CustomerProfilesGetResponse206ItemMainContactNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1CustomerProfilesPostBody::class => V1CustomerProfilesPostBodyNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1CustomerProfilesPostBodyCustomer::class => V1CustomerProfilesPostBodyCustomerNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1CustomerProfilesPostResponse201::class => V1CustomerProfilesPostResponse201Normalizer::class,

        \NoahVet\Reef\Jane\Model\V1CustomerProfilesPostResponse201BillingContact::class => V1CustomerProfilesPostResponse201BillingContactNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1CustomerProfilesPostResponse201Customer::class => V1CustomerProfilesPostResponse201CustomerNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1CustomerProfilesPostResponse201DeliveryContact::class => V1CustomerProfilesPostResponse201DeliveryContactNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1CustomerProfilesPostResponse201MainContact::class => V1CustomerProfilesPostResponse201MainContactNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1CustomerProfilesIdPatchBody::class => V1CustomerProfilesIdPatchBodyNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1CustomerProfilesIdPatchBodyBillingContact::class => V1CustomerProfilesIdPatchBodyBillingContactNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1CustomerProfilesIdPatchBodyDeliveryContact::class => V1CustomerProfilesIdPatchBodyDeliveryContactNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1CustomerProfilesIdPatchBodyMainContact::class => V1CustomerProfilesIdPatchBodyMainContactNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1CustomerProfilesIdPatchResponse200::class => V1CustomerProfilesIdPatchResponse200Normalizer::class,

        \NoahVet\Reef\Jane\Model\V1CustomerProfilesIdPatchResponse200BillingContact::class => V1CustomerProfilesIdPatchResponse200BillingContactNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1CustomerProfilesIdPatchResponse200Customer::class => V1CustomerProfilesIdPatchResponse200CustomerNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1CustomerProfilesIdPatchResponse200DeliveryContact::class => V1CustomerProfilesIdPatchResponse200DeliveryContactNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1CustomerProfilesIdPatchResponse200MainContact::class => V1CustomerProfilesIdPatchResponse200MainContactNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetsGetResponse200Item::class => V1PetsGetResponse200ItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetsGetResponse200ItemMicrochipsItem::class => V1PetsGetResponse200ItemMicrochipsItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetsGetResponse200ItemTattoo::class => V1PetsGetResponse200ItemTattooNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetsGetResponse200ItemSpecie::class => V1PetsGetResponse200ItemSpecieNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetsGetResponse206Item::class => V1PetsGetResponse206ItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetsGetResponse206ItemMicrochipsItem::class => V1PetsGetResponse206ItemMicrochipsItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetsGetResponse206ItemTattoo::class => V1PetsGetResponse206ItemTattooNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetsGetResponse206ItemSpecie::class => V1PetsGetResponse206ItemSpecieNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetsPostBody::class => V1PetsPostBodyNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetsPostBodyTattoo::class => V1PetsPostBodyTattooNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetsPostBodySpecie::class => V1PetsPostBodySpecieNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetsPostResponse201::class => V1PetsPostResponse201Normalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetsPostResponse201MicrochipsItem::class => V1PetsPostResponse201MicrochipsItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetsPostResponse201Tattoo::class => V1PetsPostResponse201TattooNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetsPostResponse201Specie::class => V1PetsPostResponse201SpecieNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetsIdPatchBody::class => V1PetsIdPatchBodyNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetsIdPatchBodyTattoo::class => V1PetsIdPatchBodyTattooNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetsIdPatchBodySpecie::class => V1PetsIdPatchBodySpecieNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetsIdPatchResponse200::class => V1PetsIdPatchResponse200Normalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetsIdPatchResponse200MicrochipsItem::class => V1PetsIdPatchResponse200MicrochipsItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetsIdPatchResponse200Tattoo::class => V1PetsIdPatchResponse200TattooNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetsIdPatchResponse200Specie::class => V1PetsIdPatchResponse200SpecieNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedsGetResponse200Item::class => V1PetBreedsGetResponse200ItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedsGetResponse200ItemAliasesItem::class => V1PetBreedsGetResponse200ItemAliasesItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedsGetResponse200ItemSpecie::class => V1PetBreedsGetResponse200ItemSpecieNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedsGetResponse206Item::class => V1PetBreedsGetResponse206ItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedsGetResponse206ItemAliasesItem::class => V1PetBreedsGetResponse206ItemAliasesItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedsGetResponse206ItemSpecie::class => V1PetBreedsGetResponse206ItemSpecieNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedsPostBody::class => V1PetBreedsPostBodyNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedsPostBodySpecie::class => V1PetBreedsPostBodySpecieNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedsPostBodyTranslations::class => V1PetBreedsPostBodyTranslationsNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedsPostBodyTranslationsEnGB::class => V1PetBreedsPostBodyTranslationsEnGBNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedsPostBodyTranslationsEnGBAliasesItem::class => V1PetBreedsPostBodyTranslationsEnGBAliasesItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedsPostBodyTranslationsFrFR::class => V1PetBreedsPostBodyTranslationsFrFRNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedsPostBodyTranslationsFrFRAliasesItem::class => V1PetBreedsPostBodyTranslationsFrFRAliasesItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedsPostResponse201::class => V1PetBreedsPostResponse201Normalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedsPostResponse201AliasesItem::class => V1PetBreedsPostResponse201AliasesItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedsPostResponse201Specie::class => V1PetBreedsPostResponse201SpecieNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedExternalLinksGetResponse200Item::class => V1PetBreedExternalLinksGetResponse200ItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedExternalLinksGetResponse200ItemExternalRef::class => V1PetBreedExternalLinksGetResponse200ItemExternalRefNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedExternalLinksGetResponse200ItemPetBreed::class => V1PetBreedExternalLinksGetResponse200ItemPetBreedNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedExternalLinksGetResponse206Item::class => V1PetBreedExternalLinksGetResponse206ItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedExternalLinksGetResponse206ItemExternalRef::class => V1PetBreedExternalLinksGetResponse206ItemExternalRefNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedExternalLinksGetResponse206ItemPetBreed::class => V1PetBreedExternalLinksGetResponse206ItemPetBreedNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedExternalLinksPostBody::class => V1PetBreedExternalLinksPostBodyNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedExternalLinksPostBodyPetBreed::class => V1PetBreedExternalLinksPostBodyPetBreedNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedExternalLinksPostBodyExternalRef::class => V1PetBreedExternalLinksPostBodyExternalRefNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedExternalLinksPostResponse201::class => V1PetBreedExternalLinksPostResponse201Normalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedExternalLinksPostResponse201ExternalRef::class => V1PetBreedExternalLinksPostResponse201ExternalRefNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedExternalLinksPostResponse201PetBreed::class => V1PetBreedExternalLinksPostResponse201PetBreedNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedExternalRefsGetResponse200Item::class => V1PetBreedExternalRefsGetResponse200ItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedExternalRefsGetResponse200ItemCoveredLocales::class => V1PetBreedExternalRefsGetResponse200ItemCoveredLocalesNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedExternalRefsGetResponse206Item::class => V1PetBreedExternalRefsGetResponse206ItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedExternalRefsGetResponse206ItemCoveredLocales::class => V1PetBreedExternalRefsGetResponse206ItemCoveredLocalesNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedExternalRefsPostBody::class => V1PetBreedExternalRefsPostBodyNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedExternalRefsPostBodyCoveredLocales::class => V1PetBreedExternalRefsPostBodyCoveredLocalesNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedExternalRefsPostResponse201::class => V1PetBreedExternalRefsPostResponse201Normalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedExternalRefsPostResponse201CoveredLocales::class => V1PetBreedExternalRefsPostResponse201CoveredLocalesNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedLabellingsGetResponse200Item::class => V1PetBreedLabellingsGetResponse200ItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedLabellingsGetResponse200ItemPetBreed::class => V1PetBreedLabellingsGetResponse200ItemPetBreedNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedLabellingsGetResponse200ItemTag::class => V1PetBreedLabellingsGetResponse200ItemTagNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedLabellingsGetResponse206Item::class => V1PetBreedLabellingsGetResponse206ItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedLabellingsGetResponse206ItemPetBreed::class => V1PetBreedLabellingsGetResponse206ItemPetBreedNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedLabellingsGetResponse206ItemTag::class => V1PetBreedLabellingsGetResponse206ItemTagNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedLabellingsPostBody::class => V1PetBreedLabellingsPostBodyNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedLabellingsPostBodyPetBreed::class => V1PetBreedLabellingsPostBodyPetBreedNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedLabellingsPostBodyTag::class => V1PetBreedLabellingsPostBodyTagNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedLabellingsPostResponse201::class => V1PetBreedLabellingsPostResponse201Normalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedLabellingsPostResponse201PetBreed::class => V1PetBreedLabellingsPostResponse201PetBreedNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedLabellingsPostResponse201Tag::class => V1PetBreedLabellingsPostResponse201TagNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedTagsGetResponse200Item::class => V1PetBreedTagsGetResponse200ItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedTagsGetResponse206Item::class => V1PetBreedTagsGetResponse206ItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedTagsPostBody::class => V1PetBreedTagsPostBodyNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedTagsPostBodyTranslations::class => V1PetBreedTagsPostBodyTranslationsNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedTagsPostBodyTranslationsEnGB::class => V1PetBreedTagsPostBodyTranslationsEnGBNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedTagsPostBodyTranslationsFrFR::class => V1PetBreedTagsPostBodyTranslationsFrFRNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetBreedTagsPostResponse201::class => V1PetBreedTagsPostResponse201Normalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetMicrochipsPostBody::class => V1PetMicrochipsPostBodyNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetMicrochipsPostBodyPet::class => V1PetMicrochipsPostBodyPetNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetMicrochipsPostResponse201::class => V1PetMicrochipsPostResponse201Normalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetMicrochipsPostResponse201Pet::class => V1PetMicrochipsPostResponse201PetNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetProfilesGetResponse200Item::class => V1PetProfilesGetResponse200ItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetProfilesGetResponse200ItemPet::class => V1PetProfilesGetResponse200ItemPetNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetProfilesGetResponse200ItemPetBreed::class => V1PetProfilesGetResponse200ItemPetBreedNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetProfilesGetResponse200ItemProfilePicture::class => V1PetProfilesGetResponse200ItemProfilePictureNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetProfilesGetResponse206Item::class => V1PetProfilesGetResponse206ItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetProfilesGetResponse206ItemPet::class => V1PetProfilesGetResponse206ItemPetNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetProfilesGetResponse206ItemPetBreed::class => V1PetProfilesGetResponse206ItemPetBreedNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetProfilesGetResponse206ItemProfilePicture::class => V1PetProfilesGetResponse206ItemProfilePictureNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetCustomerProfilesPostBody::class => V1PetCustomerProfilesPostBodyNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetCustomerProfilesPostBodyPet::class => V1PetCustomerProfilesPostBodyPetNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetCustomerProfilesPostBodyPetBreed::class => V1PetCustomerProfilesPostBodyPetBreedNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetCustomerProfilesPostBodyProfilePicture::class => V1PetCustomerProfilesPostBodyProfilePictureNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetCustomerProfilesPostResponse201::class => V1PetCustomerProfilesPostResponse201Normalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetCustomerProfilesPostResponse201Pet::class => V1PetCustomerProfilesPostResponse201PetNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetCustomerProfilesPostResponse201PetBreed::class => V1PetCustomerProfilesPostResponse201PetBreedNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetCustomerProfilesPostResponse201ProfilePicture::class => V1PetCustomerProfilesPostResponse201ProfilePictureNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetCustomerProfilesIdPatchBody::class => V1PetCustomerProfilesIdPatchBodyNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetCustomerProfilesIdPatchBodyPetBreed::class => V1PetCustomerProfilesIdPatchBodyPetBreedNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetCustomerProfilesIdPatchBodyProfilePicture::class => V1PetCustomerProfilesIdPatchBodyProfilePictureNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetCustomerProfilesIdPatchResponse200::class => V1PetCustomerProfilesIdPatchResponse200Normalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetCustomerProfilesIdPatchResponse200Pet::class => V1PetCustomerProfilesIdPatchResponse200PetNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetCustomerProfilesIdPatchResponse200PetBreed::class => V1PetCustomerProfilesIdPatchResponse200PetBreedNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetCustomerProfilesIdPatchResponse200ProfilePicture::class => V1PetCustomerProfilesIdPatchResponse200ProfilePictureNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetGhostProfilesPostBody::class => V1PetGhostProfilesPostBodyNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetGhostProfilesPostBodyPet::class => V1PetGhostProfilesPostBodyPetNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetGhostProfilesPostBodyPetBreed::class => V1PetGhostProfilesPostBodyPetBreedNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetGhostProfilesPostBodyProfilePicture::class => V1PetGhostProfilesPostBodyProfilePictureNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetGhostProfilesPostResponse201::class => V1PetGhostProfilesPostResponse201Normalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetGhostProfilesPostResponse201Pet::class => V1PetGhostProfilesPostResponse201PetNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetGhostProfilesPostResponse201PetBreed::class => V1PetGhostProfilesPostResponse201PetBreedNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetGhostProfilesPostResponse201ProfilePicture::class => V1PetGhostProfilesPostResponse201ProfilePictureNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetGhostProfilesIdPatchBody::class => V1PetGhostProfilesIdPatchBodyNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetGhostProfilesIdPatchBodyPetBreed::class => V1PetGhostProfilesIdPatchBodyPetBreedNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetGhostProfilesIdPatchBodyProfilePicture::class => V1PetGhostProfilesIdPatchBodyProfilePictureNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetGhostProfilesIdPatchResponse200::class => V1PetGhostProfilesIdPatchResponse200Normalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetGhostProfilesIdPatchResponse200Pet::class => V1PetGhostProfilesIdPatchResponse200PetNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetGhostProfilesIdPatchResponse200PetBreed::class => V1PetGhostProfilesIdPatchResponse200PetBreedNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetGhostProfilesIdPatchResponse200ProfilePicture::class => V1PetGhostProfilesIdPatchResponse200ProfilePictureNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetPatientProfilesPostBody::class => V1PetPatientProfilesPostBodyNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetPatientProfilesPostBodyPet::class => V1PetPatientProfilesPostBodyPetNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetPatientProfilesPostBodyPetBreed::class => V1PetPatientProfilesPostBodyPetBreedNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetPatientProfilesPostBodyProfilePicture::class => V1PetPatientProfilesPostBodyProfilePictureNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetPatientProfilesPostResponse201::class => V1PetPatientProfilesPostResponse201Normalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetPatientProfilesPostResponse201Pet::class => V1PetPatientProfilesPostResponse201PetNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetPatientProfilesPostResponse201PetBreed::class => V1PetPatientProfilesPostResponse201PetBreedNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetPatientProfilesPostResponse201ProfilePicture::class => V1PetPatientProfilesPostResponse201ProfilePictureNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetPatientProfilesIdPatchBody::class => V1PetPatientProfilesIdPatchBodyNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetPatientProfilesIdPatchBodyPetBreed::class => V1PetPatientProfilesIdPatchBodyPetBreedNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetPatientProfilesIdPatchBodyProfilePicture::class => V1PetPatientProfilesIdPatchBodyProfilePictureNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetPatientProfilesIdPatchResponse200::class => V1PetPatientProfilesIdPatchResponse200Normalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetPatientProfilesIdPatchResponse200Pet::class => V1PetPatientProfilesIdPatchResponse200PetNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetPatientProfilesIdPatchResponse200PetBreed::class => V1PetPatientProfilesIdPatchResponse200PetBreedNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetPatientProfilesIdPatchResponse200ProfilePicture::class => V1PetPatientProfilesIdPatchResponse200ProfilePictureNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetPublicProfilesPostBody::class => V1PetPublicProfilesPostBodyNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetPublicProfilesPostBodyPet::class => V1PetPublicProfilesPostBodyPetNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetPublicProfilesPostBodyPetBreed::class => V1PetPublicProfilesPostBodyPetBreedNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetPublicProfilesPostBodyProfilePicture::class => V1PetPublicProfilesPostBodyProfilePictureNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetPublicProfilesPostResponse201::class => V1PetPublicProfilesPostResponse201Normalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetPublicProfilesPostResponse201Pet::class => V1PetPublicProfilesPostResponse201PetNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetPublicProfilesPostResponse201PetBreed::class => V1PetPublicProfilesPostResponse201PetBreedNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetPublicProfilesPostResponse201ProfilePicture::class => V1PetPublicProfilesPostResponse201ProfilePictureNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetPublicProfilesIdPatchBody::class => V1PetPublicProfilesIdPatchBodyNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetPublicProfilesIdPatchBodyPetBreed::class => V1PetPublicProfilesIdPatchBodyPetBreedNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetPublicProfilesIdPatchBodyProfilePicture::class => V1PetPublicProfilesIdPatchBodyProfilePictureNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetPublicProfilesIdPatchResponse200::class => V1PetPublicProfilesIdPatchResponse200Normalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetPublicProfilesIdPatchResponse200Pet::class => V1PetPublicProfilesIdPatchResponse200PetNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetPublicProfilesIdPatchResponse200PetBreed::class => V1PetPublicProfilesIdPatchResponse200PetBreedNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetPublicProfilesIdPatchResponse200ProfilePicture::class => V1PetPublicProfilesIdPatchResponse200ProfilePictureNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetSpeciesGetResponse200Item::class => V1PetSpeciesGetResponse200ItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetSpeciesGetResponse200ItemAliasesItem::class => V1PetSpeciesGetResponse200ItemAliasesItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetSpeciesGetResponse206Item::class => V1PetSpeciesGetResponse206ItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\V1PetSpeciesGetResponse206ItemAliasesItem::class => V1PetSpeciesGetResponse206ItemAliasesItemNormalizer::class,

        \NoahVet\Reef\Jane\Model\OauthV2RevokeGetResponse400::class => OauthV2RevokeGetResponse400Normalizer::class,

        \NoahVet\Reef\Jane\Model\OauthV2TokenInfoTokenGetResponse200::class => OauthV2TokenInfoTokenGetResponse200Normalizer::class,

        \NoahVet\Reef\Jane\Model\OauthV2TokenInfoTokenGetResponse401::class => OauthV2TokenInfoTokenGetResponse401Normalizer::class,

        \NoahVet\Reef\Jane\Model\UserinfoGetResponse200::class => UserinfoGetResponse200Normalizer::class,

        \NoahVet\Reef\Jane\Model\UserinfoGetResponse401::class => UserinfoGetResponse401Normalizer::class,

        \Jane\Component\JsonSchemaRuntime\Reference::class => \NoahVet\Reef\Jane\Runtime\Normalizer\ReferenceNormalizer::class,
    ];

    protected $normalizersCache = [];

    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []): bool
    {
        return \array_key_exists($type, $this->normalizers);
    }

    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []): bool
    {
        return \is_object($data) && \array_key_exists($data::class, $this->normalizers);
    }

    public function normalize(mixed $data, ?string $format = null, array $context = []): array|string|int|float|bool|\ArrayObject|null
    {
        $normalizerClass = $this->normalizers[$data::class];
        $normalizer = $this->getNormalizer($normalizerClass);

        return $normalizer->normalize($data, $format, $context);
    }

    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []): mixed
    {
        $denormalizerClass = $this->normalizers[$type];
        $denormalizer = $this->getNormalizer($denormalizerClass);

        return $denormalizer->denormalize($data, $type, $format, $context);
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return [
            \NoahVet\Reef\Jane\Model\NullableIdResponse::class => false,
            \NoahVet\Reef\Jane\Model\IdResponse::class => false,
            \NoahVet\Reef\Jane\Model\BillingAccountResponseItem::class => false,
            \NoahVet\Reef\Jane\Model\NullableIdRequest::class => false,
            \NoahVet\Reef\Jane\Model\IdRequest::class => false,
            \NoahVet\Reef\Jane\Model\BillingAccountRequest::class => false,
            \NoahVet\Reef\Jane\Model\SchemasBillingAccountResponse::class => false,
            \NoahVet\Reef\Jane\Model\ComponentsSchemasBillingAccountResponse::class => false,
            \NoahVet\Reef\Jane\Model\SchemasBillingAccountRequest::class => false,
            \NoahVet\Reef\Jane\Model\BillingAccountResponseComponentsSchemasBillingAccountResponse::class => false,
            \NoahVet\Reef\Jane\Model\YousignSignatureRequestResponse::class => false,
            \NoahVet\Reef\Jane\Model\CreditNoteBankTransferRequest::class => false,
            \NoahVet\Reef\Jane\Model\CreditNoteBankTransferResponse::class => false,
            \NoahVet\Reef\Jane\Model\InvoiceDirectDebitRequest::class => false,
            \NoahVet\Reef\Jane\Model\InvoiceDirectDebitResponse::class => false,
            \NoahVet\Reef\Jane\Model\MandateResponse::class => false,
            \NoahVet\Reef\Jane\Model\ContractResponse::class => false,
            \NoahVet\Reef\Jane\Model\ContractRequest::class => false,
            \NoahVet\Reef\Jane\Model\ContractDocumentResponse::class => false,
            \NoahVet\Reef\Jane\Model\InvitationResponse::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserInvitationRequest::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserInvitationResponse::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserInvitationConfirmationRequest::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserInvitationConfirmationResponse::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryGroupUserInvitationRequest::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryGroupUserInvitationResponse::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryGroupUserInvitationConfirmationRequest::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryGroupUserInvitationConfirmationResponse::class => false,
            \NoahVet\Reef\Jane\Model\InvoiceAddressResponse::class => false,
            \NoahVet\Reef\Jane\Model\InvoiceInformationResponse::class => false,
            \NoahVet\Reef\Jane\Model\CreditNoteResponse::class => false,
            \NoahVet\Reef\Jane\Model\CreditNoteResponseAccountingMovement::class => false,
            \NoahVet\Reef\Jane\Model\CreditNoteResponseBankAccount::class => false,
            \NoahVet\Reef\Jane\Model\CreditNoteResponseCreditNoteLinesItem::class => false,
            \NoahVet\Reef\Jane\Model\InvoiceAddressRequest::class => false,
            \NoahVet\Reef\Jane\Model\CreditNoteRequest::class => false,
            \NoahVet\Reef\Jane\Model\CreditNoteRequestDeliveryInformation::class => false,
            \NoahVet\Reef\Jane\Model\CreditNoteRequestReceiverInformation::class => false,
            \NoahVet\Reef\Jane\Model\SchemasCreditNoteRequest::class => false,
            \NoahVet\Reef\Jane\Model\InvoiceResponse::class => false,
            \NoahVet\Reef\Jane\Model\InvoiceResponseAccountingMovement::class => false,
            \NoahVet\Reef\Jane\Model\InvoiceResponseBankAccount::class => false,
            \NoahVet\Reef\Jane\Model\InvoiceResponseInvoiceLinesItem::class => false,
            \NoahVet\Reef\Jane\Model\InvoiceRequest::class => false,
            \NoahVet\Reef\Jane\Model\ServiceDeliveryInvoiceRequest::class => false,
            \NoahVet\Reef\Jane\Model\ServiceDeliveryInvoiceResponse::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentCreditNoteRequest::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentCreditNoteRequestBankAccount::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentCreditNoteRequestCreditNoteLinesItem::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentCreditNoteRequestDeliveryInformation::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentInvoiceRequest::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentInvoiceRequestDeliveryInformation::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentInvoiceRequestInvoiceLinesItem::class => false,
            \NoahVet\Reef\Jane\Model\CoordinateResponse::class => false,
            \NoahVet\Reef\Jane\Model\PostalAddressResponse::class => false,
            \NoahVet\Reef\Jane\Model\LegalStructureResponseItem::class => false,
            \NoahVet\Reef\Jane\Model\CoordinateRequest::class => false,
            \NoahVet\Reef\Jane\Model\PostalAddressRequest::class => false,
            \NoahVet\Reef\Jane\Model\LegalStructureRequest::class => false,
            \NoahVet\Reef\Jane\Model\SchemasLegalStructureResponse::class => false,
            \NoahVet\Reef\Jane\Model\ComponentsSchemasLegalStructureResponse::class => false,
            \NoahVet\Reef\Jane\Model\SchemasPostalAddressRequest::class => false,
            \NoahVet\Reef\Jane\Model\SchemasLegalStructureRequest::class => false,
            \NoahVet\Reef\Jane\Model\LegalStructureResponseComponentsSchemasLegalStructureResponse::class => false,
            \NoahVet\Reef\Jane\Model\SearchRequest::class => false,
            \NoahVet\Reef\Jane\Model\LegalStructureSearchResponseItem::class => false,
            \NoahVet\Reef\Jane\Model\RequiredMandateResponseItem::class => false,
            \NoahVet\Reef\Jane\Model\RequiredMandateResponseItemFilledMandate::class => false,
            \NoahVet\Reef\Jane\Model\RequiredMandateRequest::class => false,
            \NoahVet\Reef\Jane\Model\SchemasRequiredMandateResponse::class => false,
            \NoahVet\Reef\Jane\Model\SchemasRequiredMandateResponseFilledMandate::class => false,
            \NoahVet\Reef\Jane\Model\ComponentsSchemasRequiredMandateResponse::class => false,
            \NoahVet\Reef\Jane\Model\ComponentsSchemasRequiredMandateResponseFilledMandate::class => false,
            \NoahVet\Reef\Jane\Model\ManufacturerResponseItem::class => false,
            \NoahVet\Reef\Jane\Model\ManufacturerResponseItemBanner::class => false,
            \NoahVet\Reef\Jane\Model\ManufacturerResponseItemLegalStructure::class => false,
            \NoahVet\Reef\Jane\Model\ManufacturerResponseItemLogo::class => false,
            \NoahVet\Reef\Jane\Model\ManufacturerResponseItemPicturesItem::class => false,
            \NoahVet\Reef\Jane\Model\DocumentResponse::class => false,
            \NoahVet\Reef\Jane\Model\DocumentRequest::class => false,
            \NoahVet\Reef\Jane\Model\ImageResponseItem::class => false,
            \NoahVet\Reef\Jane\Model\ImageRequest::class => false,
            \NoahVet\Reef\Jane\Model\SchemasImageResponse::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServiceDeliveryResponse::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServiceDeliveryRequest::class => false,
            \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentServiceDeliveryRequest::class => false,
            \NoahVet\Reef\Jane\Model\ServiceDeliveryOptionResponse::class => false,
            \NoahVet\Reef\Jane\Model\ServiceDeliveryOptionRequest::class => false,
            \NoahVet\Reef\Jane\Model\SchemasServiceDeliveryOptionRequest::class => false,
            \NoahVet\Reef\Jane\Model\ManufacturerUserResponseItem::class => false,
            \NoahVet\Reef\Jane\Model\ManufacturerUserResponseItemManufacturer::class => false,
            \NoahVet\Reef\Jane\Model\ManufacturerUserResponseItemUser::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserResponse::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserResponseUser::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserResponseVeterinaryEstablishment::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserRequest::class => false,
            \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentUserRequest::class => false,
            \NoahVet\Reef\Jane\Model\ComponentsSchemasVeterinaryEstablishmentUserResponse::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryGroupUserResponse::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryGroupUserResponseUser::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryGroupUserResponseVeterinaryGroup::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryGroupUserRequest::class => false,
            \NoahVet\Reef\Jane\Model\SchemasVeterinaryGroupUserRequest::class => false,
            \NoahVet\Reef\Jane\Model\ComponentsSchemasVeterinaryGroupUserResponse::class => false,
            \NoahVet\Reef\Jane\Model\OpeningHourResponse::class => false,
            \NoahVet\Reef\Jane\Model\OpeningPeriodResponse::class => false,
            \NoahVet\Reef\Jane\Model\ScheduleResponse::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentResponse::class => false,
            \NoahVet\Reef\Jane\Model\OpeningHourRequest::class => false,
            \NoahVet\Reef\Jane\Model\OpeningPeriodRequest::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentRequest::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentRequestSchedule::class => false,
            \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentRequest::class => false,
            \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentRequestSchedule::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentAddressResponse::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentAddressResponsePhone::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentAddressRequest::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentAddressRequestPhone::class => false,
            \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentAddressRequest::class => false,
            \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentAddressRequestPhone::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentMemberResponse::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentMemberRequest::class => false,
            \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentMemberRequest::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentMemberSearchRequest::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentActivityResponseItem::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentActivityRequest::class => false,
            \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentActivityResponse::class => false,
            \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentActivityRequest::class => false,
            \NoahVet\Reef\Jane\Model\ComponentsSchemasVeterinaryEstablishmentActivityResponse::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentMandateResponse::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentMandateRequest::class => false,
            \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentMandateRequest::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServicePeriodResponseItem::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServicePeriodResponseItemAttributesItem::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServiceSubscriptionResponseItem::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServiceSubscriptionResponseItemAttributesItem::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServiceSubscriptionRequest::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServiceSubscriptionRequestAttributesItem::class => false,
            \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentServiceSubscriptionResponse::class => false,
            \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentServiceSubscriptionResponseAttributesItem::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServiceSubscriptionReductionRequest::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServiceSubscriptionReductionResponse::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServiceSubscriptionReductionResponseAttributesItem::class => false,
            \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentServiceSubscriptionRequest::class => false,
            \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentServiceSubscriptionRequestAttributesItem::class => false,
            \NoahVet\Reef\Jane\Model\ComponentsSchemasVeterinaryEstablishmentServiceSubscriptionResponse::class => false,
            \NoahVet\Reef\Jane\Model\ComponentsSchemasVeterinaryEstablishmentServiceSubscriptionResponseAttributesItem::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServiceDiscountResponseItem::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServiceDiscountRequest::class => false,
            \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentServiceDiscountResponse::class => false,
            \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentServiceDiscountRequest::class => false,
            \NoahVet\Reef\Jane\Model\ComponentsSchemasVeterinaryEstablishmentServiceDiscountResponse::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServiceDeliveryDiscountResponseItem::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServiceDeliveryDiscountRequest::class => false,
            \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentServiceDeliveryDiscountResponse::class => false,
            \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentServiceDeliveryDiscountRequest::class => false,
            \NoahVet\Reef\Jane\Model\ComponentsSchemasVeterinaryEstablishmentServiceDeliveryDiscountResponse::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentLabellingResponse::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentLabellingRequest::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentTagResponse::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentTagRequest::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryGroupResponse::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryGroupRequest::class => false,
            \NoahVet\Reef\Jane\Model\SchemasVeterinaryGroupRequest::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryGroupSearchRequest::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryGroupMandateResponse::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryGroupMandateRequest::class => false,
            \NoahVet\Reef\Jane\Model\SchemasVeterinaryGroupMandateRequest::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryServiceResponseItem::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryServiceResponseItemBanner::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryServiceResponseItemCreditor::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryServiceOptionResponse::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryServiceOptionRequest::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryServiceOptionConfigResponseItem::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryServiceOptionConfigResponseItemAccountingCodesItem::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryServiceOptionConfigResponseItemVeterinaryServiceOption::class => false,
            \NoahVet\Reef\Jane\Model\YouSignContractConfirmationRequest::class => false,
            \NoahVet\Reef\Jane\Model\YouSignContractConfirmationRequestData::class => false,
            \NoahVet\Reef\Jane\Model\YouSignContractConfirmationRequestDataSignatureRequest::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentCreditNoteResponseItem::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentCreditNoteResponseItemModeration::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentCreditNoteResponseItemVeterinaryEstablishment::class => false,
            \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentCreditNoteRequest::class => false,
            \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentCreditNoteRequestModeration::class => false,
            \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentCreditNoteResponse::class => false,
            \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentCreditNoteResponseModeration::class => false,
            \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentCreditNoteResponseVeterinaryEstablishment::class => false,
            \NoahVet\Reef\Jane\Model\ComponentsSchemasVeterinaryEstablishmentCreditNoteRequest::class => false,
            \NoahVet\Reef\Jane\Model\ComponentsSchemasVeterinaryEstablishmentCreditNoteResponse::class => false,
            \NoahVet\Reef\Jane\Model\ComponentsSchemasVeterinaryEstablishmentCreditNoteResponseModeration::class => false,
            \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentCreditNoteBulkRequest::class => false,
            \NoahVet\Reef\Jane\Model\Client::class => false,
            \NoahVet\Reef\Jane\Model\ClientGet::class => false,
            \NoahVet\Reef\Jane\Model\CountryTypeEnum::class => false,
            \NoahVet\Reef\Jane\Model\GrantedPermissionShort::class => false,
            \NoahVet\Reef\Jane\Model\InvitationEmailStatusEnum::class => false,
            \NoahVet\Reef\Jane\Model\PhoneValidationMethodEnum::class => false,
            \NoahVet\Reef\Jane\Model\PolicyResultPolicyResultGet::class => false,
            \NoahVet\Reef\Jane\Model\PolicyResultPolicyResultPost::class => false,
            \NoahVet\Reef\Jane\Model\PostalAddress::class => false,
            \NoahVet\Reef\Jane\Model\Principal::class => false,
            \NoahVet\Reef\Jane\Model\PrincipalPrincipalGet::class => false,
            \NoahVet\Reef\Jane\Model\PrincipalPrincipalPatch::class => false,
            \NoahVet\Reef\Jane\Model\PrincipalPrincipalPut::class => false,
            \NoahVet\Reef\Jane\Model\PrincipalGroup::class => false,
            \NoahVet\Reef\Jane\Model\PrincipalInvitation::class => false,
            \NoahVet\Reef\Jane\Model\PrincipalPhoneNumber::class => false,
            \NoahVet\Reef\Jane\Model\PrincipalStatusEnum::class => false,
            \NoahVet\Reef\Jane\Model\PrincipalTypeEnum::class => false,
            \NoahVet\Reef\Jane\Model\Resource::class => false,
            \NoahVet\Reef\Jane\Model\ResourceGroupResourceGroupGet::class => false,
            \NoahVet\Reef\Jane\Model\ResourceGroupResourceGroupPost::class => false,
            \NoahVet\Reef\Jane\Model\ResourceGroupResourceGroupPut::class => false,
            \NoahVet\Reef\Jane\Model\ResourceType::class => false,
            \NoahVet\Reef\Jane\Model\ResourceTypeGetshort::class => false,
            \NoahVet\Reef\Jane\Model\PermissionGrant::class => false,
            \NoahVet\Reef\Jane\Model\PermissionGrantList::class => false,
            \NoahVet\Reef\Jane\Model\PrincipalShort::class => false,
            \NoahVet\Reef\Jane\Model\PrincipalGet::class => false,
            \NoahVet\Reef\Jane\Model\PrincipalGetPhoneNumbersItem::class => false,
            \NoahVet\Reef\Jane\Model\PrincipalPut::class => false,
            \NoahVet\Reef\Jane\Model\PrincipalPutPhoneNumbersItem::class => false,
            \NoahVet\Reef\Jane\Model\ServicePermission::class => false,
            \NoahVet\Reef\Jane\Model\ServiceResource::class => false,
            \NoahVet\Reef\Jane\Model\ServiceExternalResource::class => false,
            \NoahVet\Reef\Jane\Model\ServiceDefinition::class => false,
            \NoahVet\Reef\Jane\Model\ResourceGroupGet::class => false,
            \NoahVet\Reef\Jane\Model\ResourceGroupPost::class => false,
            \NoahVet\Reef\Jane\Model\ResourceGroupPut::class => false,
            \NoahVet\Reef\Jane\Model\SupplierOrderResponse::class => false,
            \NoahVet\Reef\Jane\Model\WebOrderProductResponse::class => false,
            \NoahVet\Reef\Jane\Model\WebOrderDiscountResponse::class => false,
            \NoahVet\Reef\Jane\Model\WebOrderPaymentResponse::class => false,
            \NoahVet\Reef\Jane\Model\WebOrderPatchResponse::class => false,
            \NoahVet\Reef\Jane\Model\WebOrderResponse::class => false,
            \NoahVet\Reef\Jane\Model\ProductPriceResponseItem::class => false,
            \NoahVet\Reef\Jane\Model\ProductPriceResponseItemAlcyonProduct::class => false,
            \NoahVet\Reef\Jane\Model\ProductPriceResponseItemCentravetProduct::class => false,
            \NoahVet\Reef\Jane\Model\ProductPriceResponseItemCovetoProduct::class => false,
            \NoahVet\Reef\Jane\Model\V1ContactsGetResponse200Item::class => false,
            \NoahVet\Reef\Jane\Model\V1ContactsGetResponse200ItemCompanyDetail::class => false,
            \NoahVet\Reef\Jane\Model\V1ContactsGetResponse200ItemCustomerProfile::class => false,
            \NoahVet\Reef\Jane\Model\V1ContactsGetResponse200ItemGeolocation::class => false,
            \NoahVet\Reef\Jane\Model\V1ContactsGetResponse206Item::class => false,
            \NoahVet\Reef\Jane\Model\V1ContactsGetResponse206ItemCompanyDetail::class => false,
            \NoahVet\Reef\Jane\Model\V1ContactsGetResponse206ItemCustomerProfile::class => false,
            \NoahVet\Reef\Jane\Model\V1ContactsGetResponse206ItemGeolocation::class => false,
            \NoahVet\Reef\Jane\Model\V1ContactsPostBody::class => false,
            \NoahVet\Reef\Jane\Model\V1ContactsPostBodyCompanyDetail::class => false,
            \NoahVet\Reef\Jane\Model\V1ContactsPostBodyCustomerProfile::class => false,
            \NoahVet\Reef\Jane\Model\V1ContactsPostBodyGeolocation::class => false,
            \NoahVet\Reef\Jane\Model\V1ContactsPostResponse201::class => false,
            \NoahVet\Reef\Jane\Model\V1ContactsPostResponse201CompanyDetail::class => false,
            \NoahVet\Reef\Jane\Model\V1ContactsPostResponse201CustomerProfile::class => false,
            \NoahVet\Reef\Jane\Model\V1ContactsPostResponse201Geolocation::class => false,
            \NoahVet\Reef\Jane\Model\V1ContactsIdPatchBody::class => false,
            \NoahVet\Reef\Jane\Model\V1ContactsIdPatchBodyCompanyDetail::class => false,
            \NoahVet\Reef\Jane\Model\V1ContactsIdPatchBodyGeolocation::class => false,
            \NoahVet\Reef\Jane\Model\V1ContactsIdPatchResponse200::class => false,
            \NoahVet\Reef\Jane\Model\V1ContactsIdPatchResponse200CompanyDetail::class => false,
            \NoahVet\Reef\Jane\Model\V1ContactsIdPatchResponse200CustomerProfile::class => false,
            \NoahVet\Reef\Jane\Model\V1ContactsIdPatchResponse200Geolocation::class => false,
            \NoahVet\Reef\Jane\Model\V1CustomersGetResponse200Item::class => false,
            \NoahVet\Reef\Jane\Model\V1CustomersGetResponse206Item::class => false,
            \NoahVet\Reef\Jane\Model\V1CustomersIdPatchBody::class => false,
            \NoahVet\Reef\Jane\Model\V1CustomersIdPatchResponse200::class => false,
            \NoahVet\Reef\Jane\Model\V1CustomerProfilesGetResponse200Item::class => false,
            \NoahVet\Reef\Jane\Model\V1CustomerProfilesGetResponse200ItemBillingContact::class => false,
            \NoahVet\Reef\Jane\Model\V1CustomerProfilesGetResponse200ItemCustomer::class => false,
            \NoahVet\Reef\Jane\Model\V1CustomerProfilesGetResponse200ItemDeliveryContact::class => false,
            \NoahVet\Reef\Jane\Model\V1CustomerProfilesGetResponse200ItemMainContact::class => false,
            \NoahVet\Reef\Jane\Model\V1CustomerProfilesGetResponse206Item::class => false,
            \NoahVet\Reef\Jane\Model\V1CustomerProfilesGetResponse206ItemBillingContact::class => false,
            \NoahVet\Reef\Jane\Model\V1CustomerProfilesGetResponse206ItemCustomer::class => false,
            \NoahVet\Reef\Jane\Model\V1CustomerProfilesGetResponse206ItemDeliveryContact::class => false,
            \NoahVet\Reef\Jane\Model\V1CustomerProfilesGetResponse206ItemMainContact::class => false,
            \NoahVet\Reef\Jane\Model\V1CustomerProfilesPostBody::class => false,
            \NoahVet\Reef\Jane\Model\V1CustomerProfilesPostBodyCustomer::class => false,
            \NoahVet\Reef\Jane\Model\V1CustomerProfilesPostResponse201::class => false,
            \NoahVet\Reef\Jane\Model\V1CustomerProfilesPostResponse201BillingContact::class => false,
            \NoahVet\Reef\Jane\Model\V1CustomerProfilesPostResponse201Customer::class => false,
            \NoahVet\Reef\Jane\Model\V1CustomerProfilesPostResponse201DeliveryContact::class => false,
            \NoahVet\Reef\Jane\Model\V1CustomerProfilesPostResponse201MainContact::class => false,
            \NoahVet\Reef\Jane\Model\V1CustomerProfilesIdPatchBody::class => false,
            \NoahVet\Reef\Jane\Model\V1CustomerProfilesIdPatchBodyBillingContact::class => false,
            \NoahVet\Reef\Jane\Model\V1CustomerProfilesIdPatchBodyDeliveryContact::class => false,
            \NoahVet\Reef\Jane\Model\V1CustomerProfilesIdPatchBodyMainContact::class => false,
            \NoahVet\Reef\Jane\Model\V1CustomerProfilesIdPatchResponse200::class => false,
            \NoahVet\Reef\Jane\Model\V1CustomerProfilesIdPatchResponse200BillingContact::class => false,
            \NoahVet\Reef\Jane\Model\V1CustomerProfilesIdPatchResponse200Customer::class => false,
            \NoahVet\Reef\Jane\Model\V1CustomerProfilesIdPatchResponse200DeliveryContact::class => false,
            \NoahVet\Reef\Jane\Model\V1CustomerProfilesIdPatchResponse200MainContact::class => false,
            \NoahVet\Reef\Jane\Model\V1PetsGetResponse200Item::class => false,
            \NoahVet\Reef\Jane\Model\V1PetsGetResponse200ItemMicrochipsItem::class => false,
            \NoahVet\Reef\Jane\Model\V1PetsGetResponse200ItemTattoo::class => false,
            \NoahVet\Reef\Jane\Model\V1PetsGetResponse200ItemSpecie::class => false,
            \NoahVet\Reef\Jane\Model\V1PetsGetResponse206Item::class => false,
            \NoahVet\Reef\Jane\Model\V1PetsGetResponse206ItemMicrochipsItem::class => false,
            \NoahVet\Reef\Jane\Model\V1PetsGetResponse206ItemTattoo::class => false,
            \NoahVet\Reef\Jane\Model\V1PetsGetResponse206ItemSpecie::class => false,
            \NoahVet\Reef\Jane\Model\V1PetsPostBody::class => false,
            \NoahVet\Reef\Jane\Model\V1PetsPostBodyTattoo::class => false,
            \NoahVet\Reef\Jane\Model\V1PetsPostBodySpecie::class => false,
            \NoahVet\Reef\Jane\Model\V1PetsPostResponse201::class => false,
            \NoahVet\Reef\Jane\Model\V1PetsPostResponse201MicrochipsItem::class => false,
            \NoahVet\Reef\Jane\Model\V1PetsPostResponse201Tattoo::class => false,
            \NoahVet\Reef\Jane\Model\V1PetsPostResponse201Specie::class => false,
            \NoahVet\Reef\Jane\Model\V1PetsIdPatchBody::class => false,
            \NoahVet\Reef\Jane\Model\V1PetsIdPatchBodyTattoo::class => false,
            \NoahVet\Reef\Jane\Model\V1PetsIdPatchBodySpecie::class => false,
            \NoahVet\Reef\Jane\Model\V1PetsIdPatchResponse200::class => false,
            \NoahVet\Reef\Jane\Model\V1PetsIdPatchResponse200MicrochipsItem::class => false,
            \NoahVet\Reef\Jane\Model\V1PetsIdPatchResponse200Tattoo::class => false,
            \NoahVet\Reef\Jane\Model\V1PetsIdPatchResponse200Specie::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedsGetResponse200Item::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedsGetResponse200ItemAliasesItem::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedsGetResponse200ItemSpecie::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedsGetResponse206Item::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedsGetResponse206ItemAliasesItem::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedsGetResponse206ItemSpecie::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedsPostBody::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedsPostBodySpecie::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedsPostBodyTranslations::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedsPostBodyTranslationsEnGB::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedsPostBodyTranslationsEnGBAliasesItem::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedsPostBodyTranslationsFrFR::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedsPostBodyTranslationsFrFRAliasesItem::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedsPostResponse201::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedsPostResponse201AliasesItem::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedsPostResponse201Specie::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedExternalLinksGetResponse200Item::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedExternalLinksGetResponse200ItemExternalRef::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedExternalLinksGetResponse200ItemPetBreed::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedExternalLinksGetResponse206Item::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedExternalLinksGetResponse206ItemExternalRef::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedExternalLinksGetResponse206ItemPetBreed::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedExternalLinksPostBody::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedExternalLinksPostBodyPetBreed::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedExternalLinksPostBodyExternalRef::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedExternalLinksPostResponse201::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedExternalLinksPostResponse201ExternalRef::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedExternalLinksPostResponse201PetBreed::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedExternalRefsGetResponse200Item::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedExternalRefsGetResponse200ItemCoveredLocales::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedExternalRefsGetResponse206Item::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedExternalRefsGetResponse206ItemCoveredLocales::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedExternalRefsPostBody::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedExternalRefsPostBodyCoveredLocales::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedExternalRefsPostResponse201::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedExternalRefsPostResponse201CoveredLocales::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedLabellingsGetResponse200Item::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedLabellingsGetResponse200ItemPetBreed::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedLabellingsGetResponse200ItemTag::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedLabellingsGetResponse206Item::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedLabellingsGetResponse206ItemPetBreed::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedLabellingsGetResponse206ItemTag::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedLabellingsPostBody::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedLabellingsPostBodyPetBreed::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedLabellingsPostBodyTag::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedLabellingsPostResponse201::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedLabellingsPostResponse201PetBreed::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedLabellingsPostResponse201Tag::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedTagsGetResponse200Item::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedTagsGetResponse206Item::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedTagsPostBody::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedTagsPostBodyTranslations::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedTagsPostBodyTranslationsEnGB::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedTagsPostBodyTranslationsFrFR::class => false,
            \NoahVet\Reef\Jane\Model\V1PetBreedTagsPostResponse201::class => false,
            \NoahVet\Reef\Jane\Model\V1PetMicrochipsPostBody::class => false,
            \NoahVet\Reef\Jane\Model\V1PetMicrochipsPostBodyPet::class => false,
            \NoahVet\Reef\Jane\Model\V1PetMicrochipsPostResponse201::class => false,
            \NoahVet\Reef\Jane\Model\V1PetMicrochipsPostResponse201Pet::class => false,
            \NoahVet\Reef\Jane\Model\V1PetProfilesGetResponse200Item::class => false,
            \NoahVet\Reef\Jane\Model\V1PetProfilesGetResponse200ItemPet::class => false,
            \NoahVet\Reef\Jane\Model\V1PetProfilesGetResponse200ItemPetBreed::class => false,
            \NoahVet\Reef\Jane\Model\V1PetProfilesGetResponse200ItemProfilePicture::class => false,
            \NoahVet\Reef\Jane\Model\V1PetProfilesGetResponse206Item::class => false,
            \NoahVet\Reef\Jane\Model\V1PetProfilesGetResponse206ItemPet::class => false,
            \NoahVet\Reef\Jane\Model\V1PetProfilesGetResponse206ItemPetBreed::class => false,
            \NoahVet\Reef\Jane\Model\V1PetProfilesGetResponse206ItemProfilePicture::class => false,
            \NoahVet\Reef\Jane\Model\V1PetCustomerProfilesPostBody::class => false,
            \NoahVet\Reef\Jane\Model\V1PetCustomerProfilesPostBodyPet::class => false,
            \NoahVet\Reef\Jane\Model\V1PetCustomerProfilesPostBodyPetBreed::class => false,
            \NoahVet\Reef\Jane\Model\V1PetCustomerProfilesPostBodyProfilePicture::class => false,
            \NoahVet\Reef\Jane\Model\V1PetCustomerProfilesPostResponse201::class => false,
            \NoahVet\Reef\Jane\Model\V1PetCustomerProfilesPostResponse201Pet::class => false,
            \NoahVet\Reef\Jane\Model\V1PetCustomerProfilesPostResponse201PetBreed::class => false,
            \NoahVet\Reef\Jane\Model\V1PetCustomerProfilesPostResponse201ProfilePicture::class => false,
            \NoahVet\Reef\Jane\Model\V1PetCustomerProfilesIdPatchBody::class => false,
            \NoahVet\Reef\Jane\Model\V1PetCustomerProfilesIdPatchBodyPetBreed::class => false,
            \NoahVet\Reef\Jane\Model\V1PetCustomerProfilesIdPatchBodyProfilePicture::class => false,
            \NoahVet\Reef\Jane\Model\V1PetCustomerProfilesIdPatchResponse200::class => false,
            \NoahVet\Reef\Jane\Model\V1PetCustomerProfilesIdPatchResponse200Pet::class => false,
            \NoahVet\Reef\Jane\Model\V1PetCustomerProfilesIdPatchResponse200PetBreed::class => false,
            \NoahVet\Reef\Jane\Model\V1PetCustomerProfilesIdPatchResponse200ProfilePicture::class => false,
            \NoahVet\Reef\Jane\Model\V1PetGhostProfilesPostBody::class => false,
            \NoahVet\Reef\Jane\Model\V1PetGhostProfilesPostBodyPet::class => false,
            \NoahVet\Reef\Jane\Model\V1PetGhostProfilesPostBodyPetBreed::class => false,
            \NoahVet\Reef\Jane\Model\V1PetGhostProfilesPostBodyProfilePicture::class => false,
            \NoahVet\Reef\Jane\Model\V1PetGhostProfilesPostResponse201::class => false,
            \NoahVet\Reef\Jane\Model\V1PetGhostProfilesPostResponse201Pet::class => false,
            \NoahVet\Reef\Jane\Model\V1PetGhostProfilesPostResponse201PetBreed::class => false,
            \NoahVet\Reef\Jane\Model\V1PetGhostProfilesPostResponse201ProfilePicture::class => false,
            \NoahVet\Reef\Jane\Model\V1PetGhostProfilesIdPatchBody::class => false,
            \NoahVet\Reef\Jane\Model\V1PetGhostProfilesIdPatchBodyPetBreed::class => false,
            \NoahVet\Reef\Jane\Model\V1PetGhostProfilesIdPatchBodyProfilePicture::class => false,
            \NoahVet\Reef\Jane\Model\V1PetGhostProfilesIdPatchResponse200::class => false,
            \NoahVet\Reef\Jane\Model\V1PetGhostProfilesIdPatchResponse200Pet::class => false,
            \NoahVet\Reef\Jane\Model\V1PetGhostProfilesIdPatchResponse200PetBreed::class => false,
            \NoahVet\Reef\Jane\Model\V1PetGhostProfilesIdPatchResponse200ProfilePicture::class => false,
            \NoahVet\Reef\Jane\Model\V1PetPatientProfilesPostBody::class => false,
            \NoahVet\Reef\Jane\Model\V1PetPatientProfilesPostBodyPet::class => false,
            \NoahVet\Reef\Jane\Model\V1PetPatientProfilesPostBodyPetBreed::class => false,
            \NoahVet\Reef\Jane\Model\V1PetPatientProfilesPostBodyProfilePicture::class => false,
            \NoahVet\Reef\Jane\Model\V1PetPatientProfilesPostResponse201::class => false,
            \NoahVet\Reef\Jane\Model\V1PetPatientProfilesPostResponse201Pet::class => false,
            \NoahVet\Reef\Jane\Model\V1PetPatientProfilesPostResponse201PetBreed::class => false,
            \NoahVet\Reef\Jane\Model\V1PetPatientProfilesPostResponse201ProfilePicture::class => false,
            \NoahVet\Reef\Jane\Model\V1PetPatientProfilesIdPatchBody::class => false,
            \NoahVet\Reef\Jane\Model\V1PetPatientProfilesIdPatchBodyPetBreed::class => false,
            \NoahVet\Reef\Jane\Model\V1PetPatientProfilesIdPatchBodyProfilePicture::class => false,
            \NoahVet\Reef\Jane\Model\V1PetPatientProfilesIdPatchResponse200::class => false,
            \NoahVet\Reef\Jane\Model\V1PetPatientProfilesIdPatchResponse200Pet::class => false,
            \NoahVet\Reef\Jane\Model\V1PetPatientProfilesIdPatchResponse200PetBreed::class => false,
            \NoahVet\Reef\Jane\Model\V1PetPatientProfilesIdPatchResponse200ProfilePicture::class => false,
            \NoahVet\Reef\Jane\Model\V1PetPublicProfilesPostBody::class => false,
            \NoahVet\Reef\Jane\Model\V1PetPublicProfilesPostBodyPet::class => false,
            \NoahVet\Reef\Jane\Model\V1PetPublicProfilesPostBodyPetBreed::class => false,
            \NoahVet\Reef\Jane\Model\V1PetPublicProfilesPostBodyProfilePicture::class => false,
            \NoahVet\Reef\Jane\Model\V1PetPublicProfilesPostResponse201::class => false,
            \NoahVet\Reef\Jane\Model\V1PetPublicProfilesPostResponse201Pet::class => false,
            \NoahVet\Reef\Jane\Model\V1PetPublicProfilesPostResponse201PetBreed::class => false,
            \NoahVet\Reef\Jane\Model\V1PetPublicProfilesPostResponse201ProfilePicture::class => false,
            \NoahVet\Reef\Jane\Model\V1PetPublicProfilesIdPatchBody::class => false,
            \NoahVet\Reef\Jane\Model\V1PetPublicProfilesIdPatchBodyPetBreed::class => false,
            \NoahVet\Reef\Jane\Model\V1PetPublicProfilesIdPatchBodyProfilePicture::class => false,
            \NoahVet\Reef\Jane\Model\V1PetPublicProfilesIdPatchResponse200::class => false,
            \NoahVet\Reef\Jane\Model\V1PetPublicProfilesIdPatchResponse200Pet::class => false,
            \NoahVet\Reef\Jane\Model\V1PetPublicProfilesIdPatchResponse200PetBreed::class => false,
            \NoahVet\Reef\Jane\Model\V1PetPublicProfilesIdPatchResponse200ProfilePicture::class => false,
            \NoahVet\Reef\Jane\Model\V1PetSpeciesGetResponse200Item::class => false,
            \NoahVet\Reef\Jane\Model\V1PetSpeciesGetResponse200ItemAliasesItem::class => false,
            \NoahVet\Reef\Jane\Model\V1PetSpeciesGetResponse206Item::class => false,
            \NoahVet\Reef\Jane\Model\V1PetSpeciesGetResponse206ItemAliasesItem::class => false,
            \NoahVet\Reef\Jane\Model\OauthV2RevokeGetResponse400::class => false,
            \NoahVet\Reef\Jane\Model\OauthV2TokenInfoTokenGetResponse200::class => false,
            \NoahVet\Reef\Jane\Model\OauthV2TokenInfoTokenGetResponse401::class => false,
            \NoahVet\Reef\Jane\Model\UserinfoGetResponse200::class => false,
            \NoahVet\Reef\Jane\Model\UserinfoGetResponse401::class => false,
            \Jane\Component\JsonSchemaRuntime\Reference::class => false,
        ];
    }

    private function getNormalizer(string $normalizerClass)
    {
        return $this->normalizersCache[$normalizerClass] ?? $this->initNormalizer($normalizerClass);
    }

    private function initNormalizer(string $normalizerClass)
    {
        $normalizer = new $normalizerClass();
        $normalizer->setNormalizer($this->normalizer);
        $normalizer->setDenormalizer($this->denormalizer);
        $this->normalizersCache[$normalizerClass] = $normalizer;

        return $normalizer;
    }
}
