<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class InvoiceResponseNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []): bool
    {
        return \NoahVet\Reef\Jane\Model\InvoiceResponse::class === $type;
    }

    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []): bool
    {
        return \is_object($data) && \NoahVet\Reef\Jane\Model\InvoiceResponse::class === $data::class;
    }

    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []): mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\InvoiceResponse();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('createdDate', $data)) {
            $object->setCreatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['createdDate']));
            unset($data['createdDate']);
        }
        if (\array_key_exists('updatedDate', $data)) {
            $object->setUpdatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updatedDate']));
            unset($data['updatedDate']);
        }
        if (\array_key_exists('accountingCode', $data)) {
            $object->setAccountingCode($data['accountingCode']);
            unset($data['accountingCode']);
        }
        if (\array_key_exists('accountingMovement', $data)) {
            $object->setAccountingMovement($this->denormalizer->denormalize($data['accountingMovement'], \NoahVet\Reef\Jane\Model\InvoiceResponseAccountingMovement::class, 'json', $context));
            unset($data['accountingMovement']);
        }
        if (\array_key_exists('amountWithoutVat', $data)) {
            $object->setAmountWithoutVat($data['amountWithoutVat']);
            unset($data['amountWithoutVat']);
        }
        if (\array_key_exists('amountWithVat', $data)) {
            $object->setAmountWithVat($data['amountWithVat']);
            unset($data['amountWithVat']);
        }
        if (\array_key_exists('bankAccount', $data)) {
            $object->setBankAccount($this->denormalizer->denormalize($data['bankAccount'], \NoahVet\Reef\Jane\Model\InvoiceResponseBankAccount::class, 'json', $context));
            unset($data['bankAccount']);
        }
        if (\array_key_exists('category', $data)) {
            $object->setCategory($data['category']);
            unset($data['category']);
        }
        if (\array_key_exists('deliveryAddress', $data)) {
            $object->setDeliveryAddress($this->denormalizer->denormalize($data['deliveryAddress'], \NoahVet\Reef\Jane\Model\InvoiceAddressResponse::class, 'json', $context));
            unset($data['deliveryAddress']);
        }
        if (\array_key_exists('deliveryInformation', $data)) {
            $object->setDeliveryInformation($this->denormalizer->denormalize($data['deliveryInformation'], \NoahVet\Reef\Jane\Model\InvoiceInformationResponse::class, 'json', $context));
            unset($data['deliveryInformation']);
        }
        if (\array_key_exists('entitled', $data)) {
            $object->setEntitled($data['entitled']);
            unset($data['entitled']);
        }
        if (\array_key_exists('invoiceLines', $data)) {
            $values = [];
            foreach ($data['invoiceLines'] as $value) {
                $values[] = $this->denormalizer->denormalize($value, \NoahVet\Reef\Jane\Model\InvoiceResponseInvoiceLinesItem::class, 'json', $context);
            }
            $object->setInvoiceLines($values);
            unset($data['invoiceLines']);
        }
        if (\array_key_exists('paymentMethod', $data)) {
            $object->setPaymentMethod($data['paymentMethod']);
            unset($data['paymentMethod']);
        }
        if (\array_key_exists('paymentStatus', $data)) {
            $object->setPaymentStatus($data['paymentStatus']);
            unset($data['paymentStatus']);
        }
        if (\array_key_exists('personalisedMention', $data) && null !== $data['personalisedMention']) {
            $object->setPersonalisedMention($data['personalisedMention']);
            unset($data['personalisedMention']);
        } elseif (\array_key_exists('personalisedMention', $data) && null === $data['personalisedMention']) {
            $object->setPersonalisedMention(null);
        }
        if (\array_key_exists('pdfDocument', $data)) {
            $object->setPdfDocument($this->denormalizer->denormalize($data['pdfDocument'], \NoahVet\Reef\Jane\Model\IdResponse::class, 'json', $context));
            unset($data['pdfDocument']);
        }
        if (\array_key_exists('receiverAddress', $data)) {
            $object->setReceiverAddress($this->denormalizer->denormalize($data['receiverAddress'], \NoahVet\Reef\Jane\Model\InvoiceAddressResponse::class, 'json', $context));
            unset($data['receiverAddress']);
        }
        if (\array_key_exists('receiverInformation', $data)) {
            $object->setReceiverInformation($this->denormalizer->denormalize($data['receiverInformation'], \NoahVet\Reef\Jane\Model\InvoiceInformationResponse::class, 'json', $context));
            unset($data['receiverInformation']);
        }
        if (\array_key_exists('senderAddress', $data)) {
            $object->setSenderAddress($this->denormalizer->denormalize($data['senderAddress'], \NoahVet\Reef\Jane\Model\InvoiceAddressResponse::class, 'json', $context));
            unset($data['senderAddress']);
        }
        if (\array_key_exists('senderInformation', $data)) {
            $object->setSenderInformation($this->denormalizer->denormalize($data['senderInformation'], \NoahVet\Reef\Jane\Model\InvoiceInformationResponse::class, 'json', $context));
            unset($data['senderInformation']);
        }
        foreach ($data as $key => $value_1) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_1;
            }
        }

        return $object;
    }

    public function normalize(mixed $data, ?string $format = null, array $context = []): array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        $dataArray['id'] = $data->getId();
        $dataArray['createdDate'] = $data->getCreatedDate()?->format('Y-m-d\\TH:i:sP');
        $dataArray['updatedDate'] = $data->getUpdatedDate()?->format('Y-m-d\\TH:i:sP');
        $dataArray['accountingCode'] = $data->getAccountingCode();
        $dataArray['accountingMovement'] = $this->normalizer->normalize($data->getAccountingMovement(), 'json', $context);
        $dataArray['amountWithoutVat'] = $data->getAmountWithoutVat();
        $dataArray['amountWithVat'] = $data->getAmountWithVat();
        $dataArray['bankAccount'] = $this->normalizer->normalize($data->getBankAccount(), 'json', $context);
        $dataArray['category'] = $data->getCategory();
        $dataArray['deliveryAddress'] = $this->normalizer->normalize($data->getDeliveryAddress(), 'json', $context);
        $dataArray['deliveryInformation'] = $this->normalizer->normalize($data->getDeliveryInformation(), 'json', $context);
        $dataArray['entitled'] = $data->getEntitled();
        $values = [];
        foreach ($data->getInvoiceLines() as $value) {
            $values[] = $this->normalizer->normalize($value, 'json', $context);
        }
        $dataArray['invoiceLines'] = $values;
        if ($data->isInitialized('paymentMethod') && null !== $data->getPaymentMethod()) {
            $dataArray['paymentMethod'] = $data->getPaymentMethod();
        }
        if ($data->isInitialized('paymentStatus') && null !== $data->getPaymentStatus()) {
            $dataArray['paymentStatus'] = $data->getPaymentStatus();
        }
        if ($data->isInitialized('personalisedMention') && null !== $data->getPersonalisedMention()) {
            $dataArray['personalisedMention'] = $data->getPersonalisedMention();
        }
        $dataArray['pdfDocument'] = $this->normalizer->normalize($data->getPdfDocument(), 'json', $context);
        $dataArray['receiverAddress'] = $this->normalizer->normalize($data->getReceiverAddress(), 'json', $context);
        $dataArray['receiverInformation'] = $this->normalizer->normalize($data->getReceiverInformation(), 'json', $context);
        $dataArray['senderAddress'] = $this->normalizer->normalize($data->getSenderAddress(), 'json', $context);
        $dataArray['senderInformation'] = $this->normalizer->normalize($data->getSenderInformation(), 'json', $context);
        foreach ($data as $key => $value_1) {
            if (\preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value_1;
            }
        }

        return $dataArray;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return [\NoahVet\Reef\Jane\Model\InvoiceResponse::class => false];
    }
}
