<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class ComponentsSchemasVeterinaryEstablishmentServiceSubscriptionResponseNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []): bool
    {
        return \NoahVet\Reef\Jane\Model\ComponentsSchemasVeterinaryEstablishmentServiceSubscriptionResponse::class === $type;
    }

    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []): bool
    {
        return \is_object($data) && \NoahVet\Reef\Jane\Model\ComponentsSchemasVeterinaryEstablishmentServiceSubscriptionResponse::class === $data::class;
    }

    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []): mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\ComponentsSchemasVeterinaryEstablishmentServiceSubscriptionResponse();
        if (\array_key_exists('isRenewal', $data) && \is_int($data['isRenewal'])) {
            $data['isRenewal'] = (bool) $data['isRenewal'];
        }
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('createdDate', $data)) {
            $object->setCreatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['createdDate']));
            unset($data['createdDate']);
        }
        if (\array_key_exists('updatedDate', $data)) {
            $object->setUpdatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updatedDate']));
            unset($data['updatedDate']);
        }
        if (\array_key_exists('attributes', $data)) {
            $values = [];
            foreach ($data['attributes'] as $value) {
                $values[] = $this->denormalizer->denormalize($value, \NoahVet\Reef\Jane\Model\ComponentsSchemasVeterinaryEstablishmentServiceSubscriptionResponseAttributesItem::class, 'json', $context);
            }
            $object->setAttributes($values);
            unset($data['attributes']);
        }
        if (\array_key_exists('endDate', $data)) {
            $object->setEndDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['endDate']));
            unset($data['endDate']);
        }
        if (\array_key_exists('isRenewal', $data)) {
            $object->setIsRenewal($data['isRenewal']);
            unset($data['isRenewal']);
        }
        if (\array_key_exists('paymentMethod', $data)) {
            $object->setPaymentMethod($data['paymentMethod']);
            unset($data['paymentMethod']);
        }
        if (\array_key_exists('specificBillingAccount', $data) && null !== $data['specificBillingAccount']) {
            $object->setSpecificBillingAccount($this->denormalizer->denormalize($data['specificBillingAccount'], \NoahVet\Reef\Jane\Model\NullableIdResponse::class, 'json', $context));
            unset($data['specificBillingAccount']);
        } elseif (\array_key_exists('specificBillingAccount', $data) && null === $data['specificBillingAccount']) {
            $object->setSpecificBillingAccount(null);
        }
        if (\array_key_exists('specificVeterinaryGroup', $data) && null !== $data['specificVeterinaryGroup']) {
            $object->setSpecificVeterinaryGroup($this->denormalizer->denormalize($data['specificVeterinaryGroup'], \NoahVet\Reef\Jane\Model\NullableIdResponse::class, 'json', $context));
            unset($data['specificVeterinaryGroup']);
        } elseif (\array_key_exists('specificVeterinaryGroup', $data) && null === $data['specificVeterinaryGroup']) {
            $object->setSpecificVeterinaryGroup(null);
        }
        if (\array_key_exists('startDate', $data)) {
            $object->setStartDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['startDate']));
            unset($data['startDate']);
        }
        if (\array_key_exists('veterinaryEstablishment', $data)) {
            $object->setVeterinaryEstablishment($this->denormalizer->denormalize($data['veterinaryEstablishment'], \NoahVet\Reef\Jane\Model\IdResponse::class, 'json', $context));
            unset($data['veterinaryEstablishment']);
        }
        if (\array_key_exists('veterinaryServiceOption', $data)) {
            $object->setVeterinaryServiceOption($this->denormalizer->denormalize($data['veterinaryServiceOption'], \NoahVet\Reef\Jane\Model\IdResponse::class, 'json', $context));
            unset($data['veterinaryServiceOption']);
        }
        foreach ($data as $key => $value_1) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_1;
            }
        }

        return $object;
    }

    public function normalize(mixed $data, ?string $format = null, array $context = []): array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        $dataArray['id'] = $data->getId();
        $dataArray['createdDate'] = $data->getCreatedDate()?->format('Y-m-d\\TH:i:sP');
        $dataArray['updatedDate'] = $data->getUpdatedDate()?->format('Y-m-d\\TH:i:sP');
        $values = [];
        foreach ($data->getAttributes() as $value) {
            $values[] = $this->normalizer->normalize($value, 'json', $context);
        }
        $dataArray['attributes'] = $values;
        $dataArray['endDate'] = $data->getEndDate()?->format('Y-m-d\\TH:i:sP');
        $dataArray['isRenewal'] = $data->getIsRenewal();
        $dataArray['paymentMethod'] = $data->getPaymentMethod();
        $dataArray['specificBillingAccount'] = $this->normalizer->normalize($data->getSpecificBillingAccount(), 'json', $context);
        $dataArray['specificVeterinaryGroup'] = $this->normalizer->normalize($data->getSpecificVeterinaryGroup(), 'json', $context);
        $dataArray['startDate'] = $data->getStartDate()?->format('Y-m-d\\TH:i:sP');
        $dataArray['veterinaryEstablishment'] = $this->normalizer->normalize($data->getVeterinaryEstablishment(), 'json', $context);
        $dataArray['veterinaryServiceOption'] = $this->normalizer->normalize($data->getVeterinaryServiceOption(), 'json', $context);
        foreach ($data as $key => $value_1) {
            if (\preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value_1;
            }
        }

        return $dataArray;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return [\NoahVet\Reef\Jane\Model\ComponentsSchemasVeterinaryEstablishmentServiceSubscriptionResponse::class => false];
    }
}
