<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class BillingAccountResponseItemNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []): bool
    {
        return \NoahVet\Reef\Jane\Model\BillingAccountResponseItem::class === $type;
    }

    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []): bool
    {
        return \is_object($data) && \NoahVet\Reef\Jane\Model\BillingAccountResponseItem::class === $data::class;
    }

    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []): mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\BillingAccountResponseItem();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('createdDate', $data)) {
            $object->setCreatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['createdDate']));
            unset($data['createdDate']);
        }
        if (\array_key_exists('updatedDate', $data)) {
            $object->setUpdatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updatedDate']));
            unset($data['updatedDate']);
        }
        if (\array_key_exists('bicSwift', $data) && null !== $data['bicSwift']) {
            $object->setBicSwift($data['bicSwift']);
            unset($data['bicSwift']);
        } elseif (\array_key_exists('bicSwift', $data) && null === $data['bicSwift']) {
            $object->setBicSwift(null);
        }
        if (\array_key_exists('entitled', $data)) {
            $object->setEntitled($data['entitled']);
            unset($data['entitled']);
        }
        if (\array_key_exists('file', $data) && null !== $data['file']) {
            $object->setFile($this->denormalizer->denormalize($data['file'], \NoahVet\Reef\Jane\Model\NullableIdResponse::class, 'json', $context));
            unset($data['file']);
        } elseif (\array_key_exists('file', $data) && null === $data['file']) {
            $object->setFile(null);
        }
        if (\array_key_exists('iban', $data) && null !== $data['iban']) {
            $object->setIban($data['iban']);
            unset($data['iban']);
        } elseif (\array_key_exists('iban', $data) && null === $data['iban']) {
            $object->setIban(null);
        }
        if (\array_key_exists('identityName', $data) && null !== $data['identityName']) {
            $object->setIdentityName($data['identityName']);
            unset($data['identityName']);
        } elseif (\array_key_exists('identityName', $data) && null === $data['identityName']) {
            $object->setIdentityName(null);
        }
        if (\array_key_exists('legalStructure', $data)) {
            $object->setLegalStructure($this->denormalizer->denormalize($data['legalStructure'], \NoahVet\Reef\Jane\Model\IdResponse::class, 'json', $context));
            unset($data['legalStructure']);
        }
        if (\array_key_exists('signatoryName', $data) && null !== $data['signatoryName']) {
            $object->setSignatoryName($data['signatoryName']);
            unset($data['signatoryName']);
        } elseif (\array_key_exists('signatoryName', $data) && null === $data['signatoryName']) {
            $object->setSignatoryName(null);
        }
        if (\array_key_exists('status', $data) && null !== $data['status']) {
            $object->setStatus($data['status']);
            unset($data['status']);
        } elseif (\array_key_exists('status', $data) && null === $data['status']) {
            $object->setStatus(null);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    public function normalize(mixed $data, ?string $format = null, array $context = []): array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        $dataArray['id'] = $data->getId();
        $dataArray['createdDate'] = $data->getCreatedDate()?->format('Y-m-d\\TH:i:sP');
        $dataArray['updatedDate'] = $data->getUpdatedDate()?->format('Y-m-d\\TH:i:sP');
        $dataArray['bicSwift'] = $data->getBicSwift();
        $dataArray['entitled'] = $data->getEntitled();
        $dataArray['file'] = $this->normalizer->normalize($data->getFile(), 'json', $context);
        $dataArray['iban'] = $data->getIban();
        $dataArray['identityName'] = $data->getIdentityName();
        $dataArray['legalStructure'] = $this->normalizer->normalize($data->getLegalStructure(), 'json', $context);
        $dataArray['signatoryName'] = $data->getSignatoryName();
        $dataArray['status'] = $data->getStatus();
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }

        return $dataArray;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return [\NoahVet\Reef\Jane\Model\BillingAccountResponseItem::class => false];
    }
}
