<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class YouSignContractConfirmationRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var YouSignContractConfirmationRequestData
     */
    protected $data;

    /**
     * @var string
     */
    protected $eventId;

    /**
     * @var string
     */
    protected $eventName;

    /**
     * @var string
     */
    protected $eventTime;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getData(): YouSignContractConfirmationRequestData
    {
        return $this->data;
    }

    public function setData(YouSignContractConfirmationRequestData $data): self
    {
        $this->initialized['data'] = true;
        $this->data = $data;

        return $this;
    }

    public function getEventId(): string
    {
        return $this->eventId;
    }

    public function setEventId(string $eventId): self
    {
        $this->initialized['eventId'] = true;
        $this->eventId = $eventId;

        return $this;
    }

    public function getEventName(): string
    {
        return $this->eventName;
    }

    public function setEventName(string $eventName): self
    {
        $this->initialized['eventName'] = true;
        $this->eventName = $eventName;

        return $this;
    }

    public function getEventTime(): string
    {
        return $this->eventTime;
    }

    public function setEventTime(string $eventTime): self
    {
        $this->initialized['eventTime'] = true;
        $this->eventTime = $eventTime;

        return $this;
    }
}
