<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class WebOrderResponse extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var int
     */
    protected $mvsId;

    /**
     * @var string
     */
    protected $reference;

    /**
     * @var \DateTime
     */
    protected $invoiceDate;

    /**
     * @var int
     */
    protected $state;

    /**
     * @var string
     */
    protected $supplier;

    /**
     * @var string
     */
    protected $establishmentCode;

    /**
     * @var string
     */
    protected $establishmentName;

    /**
     * @var string
     */
    protected $establishmentSupplierCode;

    /**
     * @var float
     */
    protected $totalPrice;

    /**
     * @var float
     */
    protected $totalPaying;

    /**
     * @var float
     */
    protected $totalYearEndDiscount;

    /**
     * @var float
     */
    protected $totalDiscount;

    /**
     * @var float
     */
    protected $totalBankFee;

    /**
     * @var float
     */
    protected $netPaying;

    /**
     * @var float
     */
    protected $netYearEndDiscount;

    /**
     * @var string|null
     */
    protected $veterinaryEstablishmentId;

    /**
     * @var float
     */
    protected $totalPayingDiscount;

    /**
     * @var float
     */
    protected $totalPayingPatch;

    /**
     * @var float
     */
    protected $totalYearEndDiscountDiscount;

    /**
     * @var float
     */
    protected $totalYearEndDiscountPatch;

    /**
     * @var float
     */
    protected $valuedTotalPrice;

    /**
     * @var float
     */
    protected $totalPayable;

    /**
     * @var float
     */
    protected $totalYearEndDiscountable;

    /**
     * @var list<WebOrderProductResponse>
     */
    protected $products;

    /**
     * @var list<WebOrderDiscountResponse>
     */
    protected $discounts;

    /**
     * @var list<WebOrderPaymentResponse>
     */
    protected $payments;

    /**
     * @var list<WebOrderPatchResponse>
     */
    protected $patches;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getMvsId(): int
    {
        return $this->mvsId;
    }

    public function setMvsId(int $mvsId): self
    {
        $this->initialized['mvsId'] = true;
        $this->mvsId = $mvsId;

        return $this;
    }

    public function getReference(): string
    {
        return $this->reference;
    }

    public function setReference(string $reference): self
    {
        $this->initialized['reference'] = true;
        $this->reference = $reference;

        return $this;
    }

    public function getInvoiceDate(): \DateTime
    {
        return $this->invoiceDate;
    }

    public function setInvoiceDate(\DateTime $invoiceDate): self
    {
        $this->initialized['invoiceDate'] = true;
        $this->invoiceDate = $invoiceDate;

        return $this;
    }

    public function getState(): int
    {
        return $this->state;
    }

    public function setState(int $state): self
    {
        $this->initialized['state'] = true;
        $this->state = $state;

        return $this;
    }

    public function getSupplier(): string
    {
        return $this->supplier;
    }

    public function setSupplier(string $supplier): self
    {
        $this->initialized['supplier'] = true;
        $this->supplier = $supplier;

        return $this;
    }

    public function getEstablishmentCode(): string
    {
        return $this->establishmentCode;
    }

    public function setEstablishmentCode(string $establishmentCode): self
    {
        $this->initialized['establishmentCode'] = true;
        $this->establishmentCode = $establishmentCode;

        return $this;
    }

    public function getEstablishmentName(): string
    {
        return $this->establishmentName;
    }

    public function setEstablishmentName(string $establishmentName): self
    {
        $this->initialized['establishmentName'] = true;
        $this->establishmentName = $establishmentName;

        return $this;
    }

    public function getEstablishmentSupplierCode(): string
    {
        return $this->establishmentSupplierCode;
    }

    public function setEstablishmentSupplierCode(string $establishmentSupplierCode): self
    {
        $this->initialized['establishmentSupplierCode'] = true;
        $this->establishmentSupplierCode = $establishmentSupplierCode;

        return $this;
    }

    public function getTotalPrice(): float
    {
        return $this->totalPrice;
    }

    public function setTotalPrice(float $totalPrice): self
    {
        $this->initialized['totalPrice'] = true;
        $this->totalPrice = $totalPrice;

        return $this;
    }

    public function getTotalPaying(): float
    {
        return $this->totalPaying;
    }

    public function setTotalPaying(float $totalPaying): self
    {
        $this->initialized['totalPaying'] = true;
        $this->totalPaying = $totalPaying;

        return $this;
    }

    public function getTotalYearEndDiscount(): float
    {
        return $this->totalYearEndDiscount;
    }

    public function setTotalYearEndDiscount(float $totalYearEndDiscount): self
    {
        $this->initialized['totalYearEndDiscount'] = true;
        $this->totalYearEndDiscount = $totalYearEndDiscount;

        return $this;
    }

    public function getTotalDiscount(): float
    {
        return $this->totalDiscount;
    }

    public function setTotalDiscount(float $totalDiscount): self
    {
        $this->initialized['totalDiscount'] = true;
        $this->totalDiscount = $totalDiscount;

        return $this;
    }

    public function getTotalBankFee(): float
    {
        return $this->totalBankFee;
    }

    public function setTotalBankFee(float $totalBankFee): self
    {
        $this->initialized['totalBankFee'] = true;
        $this->totalBankFee = $totalBankFee;

        return $this;
    }

    public function getNetPaying(): float
    {
        return $this->netPaying;
    }

    public function setNetPaying(float $netPaying): self
    {
        $this->initialized['netPaying'] = true;
        $this->netPaying = $netPaying;

        return $this;
    }

    public function getNetYearEndDiscount(): float
    {
        return $this->netYearEndDiscount;
    }

    public function setNetYearEndDiscount(float $netYearEndDiscount): self
    {
        $this->initialized['netYearEndDiscount'] = true;
        $this->netYearEndDiscount = $netYearEndDiscount;

        return $this;
    }

    public function getVeterinaryEstablishmentId(): ?string
    {
        return $this->veterinaryEstablishmentId;
    }

    public function setVeterinaryEstablishmentId(?string $veterinaryEstablishmentId): self
    {
        $this->initialized['veterinaryEstablishmentId'] = true;
        $this->veterinaryEstablishmentId = $veterinaryEstablishmentId;

        return $this;
    }

    public function getTotalPayingDiscount(): float
    {
        return $this->totalPayingDiscount;
    }

    public function setTotalPayingDiscount(float $totalPayingDiscount): self
    {
        $this->initialized['totalPayingDiscount'] = true;
        $this->totalPayingDiscount = $totalPayingDiscount;

        return $this;
    }

    public function getTotalPayingPatch(): float
    {
        return $this->totalPayingPatch;
    }

    public function setTotalPayingPatch(float $totalPayingPatch): self
    {
        $this->initialized['totalPayingPatch'] = true;
        $this->totalPayingPatch = $totalPayingPatch;

        return $this;
    }

    public function getTotalYearEndDiscountDiscount(): float
    {
        return $this->totalYearEndDiscountDiscount;
    }

    public function setTotalYearEndDiscountDiscount(float $totalYearEndDiscountDiscount): self
    {
        $this->initialized['totalYearEndDiscountDiscount'] = true;
        $this->totalYearEndDiscountDiscount = $totalYearEndDiscountDiscount;

        return $this;
    }

    public function getTotalYearEndDiscountPatch(): float
    {
        return $this->totalYearEndDiscountPatch;
    }

    public function setTotalYearEndDiscountPatch(float $totalYearEndDiscountPatch): self
    {
        $this->initialized['totalYearEndDiscountPatch'] = true;
        $this->totalYearEndDiscountPatch = $totalYearEndDiscountPatch;

        return $this;
    }

    public function getValuedTotalPrice(): float
    {
        return $this->valuedTotalPrice;
    }

    public function setValuedTotalPrice(float $valuedTotalPrice): self
    {
        $this->initialized['valuedTotalPrice'] = true;
        $this->valuedTotalPrice = $valuedTotalPrice;

        return $this;
    }

    public function getTotalPayable(): float
    {
        return $this->totalPayable;
    }

    public function setTotalPayable(float $totalPayable): self
    {
        $this->initialized['totalPayable'] = true;
        $this->totalPayable = $totalPayable;

        return $this;
    }

    public function getTotalYearEndDiscountable(): float
    {
        return $this->totalYearEndDiscountable;
    }

    public function setTotalYearEndDiscountable(float $totalYearEndDiscountable): self
    {
        $this->initialized['totalYearEndDiscountable'] = true;
        $this->totalYearEndDiscountable = $totalYearEndDiscountable;

        return $this;
    }

    /**
     * @return list<WebOrderProductResponse>
     */
    public function getProducts(): array
    {
        return $this->products;
    }

    /**
     * @param list<WebOrderProductResponse> $products
     */
    public function setProducts(array $products): self
    {
        $this->initialized['products'] = true;
        $this->products = $products;

        return $this;
    }

    /**
     * @return list<WebOrderDiscountResponse>
     */
    public function getDiscounts(): array
    {
        return $this->discounts;
    }

    /**
     * @param list<WebOrderDiscountResponse> $discounts
     */
    public function setDiscounts(array $discounts): self
    {
        $this->initialized['discounts'] = true;
        $this->discounts = $discounts;

        return $this;
    }

    /**
     * @return list<WebOrderPaymentResponse>
     */
    public function getPayments(): array
    {
        return $this->payments;
    }

    /**
     * @param list<WebOrderPaymentResponse> $payments
     */
    public function setPayments(array $payments): self
    {
        $this->initialized['payments'] = true;
        $this->payments = $payments;

        return $this;
    }

    /**
     * @return list<WebOrderPatchResponse>
     */
    public function getPatches(): array
    {
        return $this->patches;
    }

    /**
     * @param list<WebOrderPatchResponse> $patches
     */
    public function setPatches(array $patches): self
    {
        $this->initialized['patches'] = true;
        $this->patches = $patches;

        return $this;
    }
}
