<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class WebOrderPaymentResponse extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var int
     */
    protected $mvsId;

    /**
     * @var string
     */
    protected $platform;

    /**
     * @var float
     */
    protected $amount;

    /**
     * @var float
     */
    protected $bankFeeFix;

    /**
     * @var float
     */
    protected $bankFeeRate;

    /**
     * @var float
     */
    protected $bankFee;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getMvsId(): int
    {
        return $this->mvsId;
    }

    public function setMvsId(int $mvsId): self
    {
        $this->initialized['mvsId'] = true;
        $this->mvsId = $mvsId;

        return $this;
    }

    public function getPlatform(): string
    {
        return $this->platform;
    }

    public function setPlatform(string $platform): self
    {
        $this->initialized['platform'] = true;
        $this->platform = $platform;

        return $this;
    }

    public function getAmount(): float
    {
        return $this->amount;
    }

    public function setAmount(float $amount): self
    {
        $this->initialized['amount'] = true;
        $this->amount = $amount;

        return $this;
    }

    public function getBankFeeFix(): float
    {
        return $this->bankFeeFix;
    }

    public function setBankFeeFix(float $bankFeeFix): self
    {
        $this->initialized['bankFeeFix'] = true;
        $this->bankFeeFix = $bankFeeFix;

        return $this;
    }

    public function getBankFeeRate(): float
    {
        return $this->bankFeeRate;
    }

    public function setBankFeeRate(float $bankFeeRate): self
    {
        $this->initialized['bankFeeRate'] = true;
        $this->bankFeeRate = $bankFeeRate;

        return $this;
    }

    public function getBankFee(): float
    {
        return $this->bankFee;
    }

    public function setBankFee(float $bankFee): self
    {
        $this->initialized['bankFee'] = true;
        $this->bankFee = $bankFee;

        return $this;
    }
}
