<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class WebOrderDiscountResponse extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var int
     */
    protected $mvsId;

    /**
     * @var string
     */
    protected $code;

    /**
     * @var string
     */
    protected $name;

    /**
     * @var string
     */
    protected $type;

    /**
     * @var float
     */
    protected $amount;

    /**
     * @var float
     */
    protected $valuedAmount;

    /**
     * @var float
     */
    protected $paying;

    /**
     * @var float
     */
    protected $yearEndDiscount;

    /**
     * @var float
     */
    protected $payRate;

    /**
     * @var float
     */
    protected $yearEndDiscountRate;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getMvsId(): int
    {
        return $this->mvsId;
    }

    public function setMvsId(int $mvsId): self
    {
        $this->initialized['mvsId'] = true;
        $this->mvsId = $mvsId;

        return $this;
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function setCode(string $code): self
    {
        $this->initialized['code'] = true;
        $this->code = $code;

        return $this;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->initialized['name'] = true;
        $this->name = $name;

        return $this;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function setType(string $type): self
    {
        $this->initialized['type'] = true;
        $this->type = $type;

        return $this;
    }

    public function getAmount(): float
    {
        return $this->amount;
    }

    public function setAmount(float $amount): self
    {
        $this->initialized['amount'] = true;
        $this->amount = $amount;

        return $this;
    }

    public function getValuedAmount(): float
    {
        return $this->valuedAmount;
    }

    public function setValuedAmount(float $valuedAmount): self
    {
        $this->initialized['valuedAmount'] = true;
        $this->valuedAmount = $valuedAmount;

        return $this;
    }

    public function getPaying(): float
    {
        return $this->paying;
    }

    public function setPaying(float $paying): self
    {
        $this->initialized['paying'] = true;
        $this->paying = $paying;

        return $this;
    }

    public function getYearEndDiscount(): float
    {
        return $this->yearEndDiscount;
    }

    public function setYearEndDiscount(float $yearEndDiscount): self
    {
        $this->initialized['yearEndDiscount'] = true;
        $this->yearEndDiscount = $yearEndDiscount;

        return $this;
    }

    public function getPayRate(): float
    {
        return $this->payRate;
    }

    public function setPayRate(float $payRate): self
    {
        $this->initialized['payRate'] = true;
        $this->payRate = $payRate;

        return $this;
    }

    public function getYearEndDiscountRate(): float
    {
        return $this->yearEndDiscountRate;
    }

    public function setYearEndDiscountRate(float $yearEndDiscountRate): self
    {
        $this->initialized['yearEndDiscountRate'] = true;
        $this->yearEndDiscountRate = $yearEndDiscountRate;

        return $this;
    }
}
