<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class VeterinaryServiceOptionRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string|null
     */
    protected $invoiceLineEntitledPattern;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getInvoiceLineEntitledPattern(): ?string
    {
        return $this->invoiceLineEntitledPattern;
    }

    public function setInvoiceLineEntitledPattern(?string $invoiceLineEntitledPattern): self
    {
        $this->initialized['invoiceLineEntitledPattern'] = true;
        $this->invoiceLineEntitledPattern = $invoiceLineEntitledPattern;

        return $this;
    }
}
