<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class VeterinaryEstablishmentServiceDeliveryRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $accountingCode;

    /**
     * @var \DateTime|null
     */
    protected $completionDate;

    /**
     * @var string|null
     */
    protected $internalCommentary;

    /**
     * @var \DateTime|null
     */
    protected $invoiceDate;

    /**
     * @var string|null
     */
    protected $longDescription;

    /**
     * @var string
     */
    protected $paymentMethod;

    /**
     * Id - Common Request Model.
     *
     * @var IdRequest
     */
    protected $serviceDeliveryOption;

    /**
     * Nullable Id - Common Request Model.
     *
     * @var NullableIdRequest|null
     */
    protected $specificBillingAccount;

    /**
     * Nullable Id - Common Request Model.
     *
     * @var NullableIdRequest|null
     */
    protected $specificVeterinaryGroup;

    /**
     * Id - Common Request Model.
     *
     * @var IdRequest
     */
    protected $veterinaryEstablishment;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getAccountingCode(): string
    {
        return $this->accountingCode;
    }

    public function setAccountingCode(string $accountingCode): self
    {
        $this->initialized['accountingCode'] = true;
        $this->accountingCode = $accountingCode;

        return $this;
    }

    public function getCompletionDate(): ?\DateTime
    {
        return $this->completionDate;
    }

    public function setCompletionDate(?\DateTime $completionDate): self
    {
        $this->initialized['completionDate'] = true;
        $this->completionDate = $completionDate;

        return $this;
    }

    public function getInternalCommentary(): ?string
    {
        return $this->internalCommentary;
    }

    public function setInternalCommentary(?string $internalCommentary): self
    {
        $this->initialized['internalCommentary'] = true;
        $this->internalCommentary = $internalCommentary;

        return $this;
    }

    public function getInvoiceDate(): ?\DateTime
    {
        return $this->invoiceDate;
    }

    public function setInvoiceDate(?\DateTime $invoiceDate): self
    {
        $this->initialized['invoiceDate'] = true;
        $this->invoiceDate = $invoiceDate;

        return $this;
    }

    public function getLongDescription(): ?string
    {
        return $this->longDescription;
    }

    public function setLongDescription(?string $longDescription): self
    {
        $this->initialized['longDescription'] = true;
        $this->longDescription = $longDescription;

        return $this;
    }

    public function getPaymentMethod(): string
    {
        return $this->paymentMethod;
    }

    public function setPaymentMethod(string $paymentMethod): self
    {
        $this->initialized['paymentMethod'] = true;
        $this->paymentMethod = $paymentMethod;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getServiceDeliveryOption(): IdRequest
    {
        return $this->serviceDeliveryOption;
    }

    /**
     * Id - Common Request Model.
     */
    public function setServiceDeliveryOption(IdRequest $serviceDeliveryOption): self
    {
        $this->initialized['serviceDeliveryOption'] = true;
        $this->serviceDeliveryOption = $serviceDeliveryOption;

        return $this;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function getSpecificBillingAccount(): ?NullableIdRequest
    {
        return $this->specificBillingAccount;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function setSpecificBillingAccount(?NullableIdRequest $specificBillingAccount): self
    {
        $this->initialized['specificBillingAccount'] = true;
        $this->specificBillingAccount = $specificBillingAccount;

        return $this;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function getSpecificVeterinaryGroup(): ?NullableIdRequest
    {
        return $this->specificVeterinaryGroup;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function setSpecificVeterinaryGroup(?NullableIdRequest $specificVeterinaryGroup): self
    {
        $this->initialized['specificVeterinaryGroup'] = true;
        $this->specificVeterinaryGroup = $specificVeterinaryGroup;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getVeterinaryEstablishment(): IdRequest
    {
        return $this->veterinaryEstablishment;
    }

    /**
     * Id - Common Request Model.
     */
    public function setVeterinaryEstablishment(IdRequest $veterinaryEstablishment): self
    {
        $this->initialized['veterinaryEstablishment'] = true;
        $this->veterinaryEstablishment = $veterinaryEstablishment;

        return $this;
    }
}
