<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class VeterinaryEstablishmentServiceDeliveryDiscountResponseItem extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var \DateTime
     */
    protected $createdDate;

    /**
     * @var \DateTime
     */
    protected $updatedDate;

    /**
     * @var string
     */
    protected $accountingCode;

    /**
     * @var int
     */
    protected $amount;

    /**
     * @var string
     */
    protected $entitled;

    /**
     * @var string|null
     */
    protected $internalCommentary;

    /**
     * Id - Response Model.
     *
     * @var IdResponse
     */
    protected $veterinaryEstablishmentServiceDelivery;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getCreatedDate(): \DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(\DateTime $createdDate): self
    {
        $this->initialized['createdDate'] = true;
        $this->createdDate = $createdDate;

        return $this;
    }

    public function getUpdatedDate(): \DateTime
    {
        return $this->updatedDate;
    }

    public function setUpdatedDate(\DateTime $updatedDate): self
    {
        $this->initialized['updatedDate'] = true;
        $this->updatedDate = $updatedDate;

        return $this;
    }

    public function getAccountingCode(): string
    {
        return $this->accountingCode;
    }

    public function setAccountingCode(string $accountingCode): self
    {
        $this->initialized['accountingCode'] = true;
        $this->accountingCode = $accountingCode;

        return $this;
    }

    public function getAmount(): int
    {
        return $this->amount;
    }

    public function setAmount(int $amount): self
    {
        $this->initialized['amount'] = true;
        $this->amount = $amount;

        return $this;
    }

    public function getEntitled(): string
    {
        return $this->entitled;
    }

    public function setEntitled(string $entitled): self
    {
        $this->initialized['entitled'] = true;
        $this->entitled = $entitled;

        return $this;
    }

    public function getInternalCommentary(): ?string
    {
        return $this->internalCommentary;
    }

    public function setInternalCommentary(?string $internalCommentary): self
    {
        $this->initialized['internalCommentary'] = true;
        $this->internalCommentary = $internalCommentary;

        return $this;
    }

    /**
     * Id - Response Model.
     */
    public function getVeterinaryEstablishmentServiceDelivery(): IdResponse
    {
        return $this->veterinaryEstablishmentServiceDelivery;
    }

    /**
     * Id - Response Model.
     */
    public function setVeterinaryEstablishmentServiceDelivery(IdResponse $veterinaryEstablishmentServiceDelivery): self
    {
        $this->initialized['veterinaryEstablishmentServiceDelivery'] = true;
        $this->veterinaryEstablishmentServiceDelivery = $veterinaryEstablishmentServiceDelivery;

        return $this;
    }
}
